/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;

public class DumpData {
    private DataType dt;
    private long offset;
    private String name;
    private boolean generateSymbol;
    private boolean generateFragment;
    private long size;
    private AddressSpace space;

    public DumpData(long offset, DataType dt) {
        this(offset, dt, dt.getDisplayName(), false, true);
    }

    public DumpData(long offset, DataType dt, String name) {
        this(offset, dt, name, true, true);
    }

    public DumpData(long offset, DataType dt, String name, boolean genSymbol, boolean genFragment) {
        this.offset = offset;
        this.dt = dt;
        this.name = name;
        this.generateSymbol = genSymbol;
        this.generateFragment = genFragment;
        this.size = dt.getLength();
    }

    public DumpData(long offset, String name, int size) {
        this.offset = offset;
        this.dt = null;
        this.name = name;
        this.generateSymbol = true;
        this.generateFragment = true;
        this.size = size;
    }

    public DataType getDataType() {
        return this.dt;
    }

    public void setDataType(DataType dt) {
        this.dt = dt;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGenerateSymbol() {
        return this.generateSymbol;
    }

    public void setGenerateSymbol(boolean genSymbol) {
        this.generateSymbol = genSymbol;
    }

    public boolean isGenerateFragment() {
        return this.generateFragment;
    }

    public void setGenerateFragment(boolean genFragment) {
        this.generateFragment = genFragment;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public AddressSpace getAddressSpace() {
        return this.space;
    }

    public void setAddressSpace(AddressSpace space) {
        this.space = space;
    }
}

