/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatInstructionSet;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class OatHeader_007
extends OatHeader {
    protected int adler32_checksum_;
    protected int instruction_set_;
    protected int dex_file_count_;
    protected int executable_offset_;
    protected int interpreter_to_interpreter_bridge_offset_;
    protected int interpreter_to_compiled_code_bridge_offset_;
    protected int jni_dlsym_lookup_offset_;
    protected int portable_resolution_trampoline_offset_;
    protected int portable_to_interpreter_bridge_offset_;
    protected int image_file_location_oat_checksum_;
    protected int image_file_location_oat_data_begin_;
    protected int image_file_location_size_;
    protected byte[] image_file_location_data_;

    public OatHeader_007(BinaryReader reader) throws IOException {
        super(reader);
        this.adler32_checksum_ = reader.readNextInt();
        this.instruction_set_ = reader.readNextInt();
        this.dex_file_count_ = reader.readNextInt();
        this.executable_offset_ = reader.readNextInt();
        this.interpreter_to_interpreter_bridge_offset_ = reader.readNextInt();
        this.interpreter_to_compiled_code_bridge_offset_ = reader.readNextInt();
        this.jni_dlsym_lookup_offset_ = reader.readNextInt();
        this.portable_resolution_trampoline_offset_ = reader.readNextInt();
        this.portable_to_interpreter_bridge_offset_ = reader.readNextInt();
        this.image_file_location_oat_checksum_ = reader.readNextInt();
        this.image_file_location_oat_data_begin_ = reader.readNextInt();
        this.image_file_location_size_ = reader.readNextInt();
    }

    @Override
    public void parse(BinaryReader reader, OatBundle bundle) throws IOException {
    }

    @Override
    public int getOatDexFilesOffset(BinaryReader reader) {
        return -1;
    }

    @Override
    public int getChecksum() {
        return this.adler32_checksum_;
    }

    @Override
    public OatInstructionSet getInstructionSet() {
        return OatInstructionSet.valueOf(this.instruction_set_);
    }

    @Override
    public int getDexFileCount() {
        return this.dex_file_count_;
    }

    @Override
    public int getExecutableOffset() {
        return this.executable_offset_;
    }

    public int getInterpreterToInterpreterBridgeOffset() {
        return this.interpreter_to_interpreter_bridge_offset_;
    }

    public int getInterpreterToCompiledCodeBridgeOffset() {
        return this.interpreter_to_compiled_code_bridge_offset_;
    }

    public int getJniDlsymLookupOffset() {
        return this.jni_dlsym_lookup_offset_;
    }

    public int getPortableResolutionTrampolineOffset() {
        return this.portable_resolution_trampoline_offset_;
    }

    public int getPortableToInterpreterBridgeOffset() {
        return this.portable_to_interpreter_bridge_offset_;
    }

    public int getImageFileLocationOatChecksum() {
        return this.image_file_location_oat_checksum_;
    }

    public int getImageFileLocationOatDataBegin() {
        return this.image_file_location_oat_data_begin_;
    }

    public int getImageFileLocationSize_() {
        return this.image_file_location_size_;
    }

    public byte[] getImageFileLocationData_() {
        return this.image_file_location_data_;
    }

    @Override
    public int getKeyValueStoreSize() {
        return 0;
    }

    @Override
    public List<OatDexFile> getOatDexFileList() {
        return Collections.emptyList();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "adler32_checksum_", null);
        structure.add(DWORD, "instruction_set_", null);
        structure.add(DWORD, "dex_file_count_", null);
        structure.add(DWORD, "executable_offset_", null);
        structure.add(DWORD, "interpreter_to_interpreter_bridge_offset_", null);
        structure.add(DWORD, "interpreter_to_compiled_code_bridge_offset_", null);
        structure.add(DWORD, "jni_dlsym_lookup_offset_", null);
        structure.add(DWORD, "portable_resolution_trampoline_offset_", null);
        structure.add(DWORD, "portable_to_interpreter_bridge_offset_", null);
        structure.add(DWORD, "image_file_location_oat_checksum_", null);
        structure.add(DWORD, "image_file_location_oat_data_begin_", null);
        structure.add(DWORD, "image_file_location_size_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }
}

