/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractColorDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.RGB16EncodingSettingsDefinition;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.DataConverter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RGB16ColorDataType
extends AbstractColorDataType {
    public static RGB16ColorDataType datatype = new RGB16ColorDataType();
    private static int LENGTH = 2;
    private static TypeDefSettingsDefinition[] RGB16_TYPEDEF_SETTINGS = TypeDefSettingsDefinition.concat(UnsignedIntegerDataType.dataType.getTypeDefSettingsDefinitions(), RGB16EncodingSettingsDefinition.DEF);

    public static TypedefDataType createRGB16Typedef(RGB16EncodingSettingsDefinition.RGB16Encoding rgb16Encoding) {
        Objects.requireNonNull(rgb16Encoding, "RGB16Encoding required");
        TypedefDataType dt = new TypedefDataType(rgb16Encoding.name(), datatype);
        Settings settings = dt.getDefaultSettings();
        RGB16EncodingSettingsDefinition.DEF.setRGBEncoding(settings, rgb16Encoding);
        return dt;
    }

    public RGB16ColorDataType() {
        this(null);
    }

    public RGB16ColorDataType(DataTypeManager dtm) {
        super("RGB16", dtm);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RGB16ColorDataType(dtm);
    }

    @Override
    public int getLength() {
        return LENGTH;
    }

    @Override
    public String getDescription() {
        return "An RGB color with 16-bit encoding (default encoding is RGB_565, use Typedef for other 16-bit encodings)";
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return RGB16_TYPEDEF_SETTINGS;
    }

    @Override
    protected Color decodeColor(MemBuffer buf, Settings settings) {
        byte[] bytes = new byte[LENGTH];
        buf.getBytes(bytes, 0);
        short value = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf)).getShort(bytes, 0);
        int argbValue = 0;
        RGB16EncodingSettingsDefinition.RGB16Encoding rgbEncoding = RGB16EncodingSettingsDefinition.DEF.getRGBEncoding(settings);
        switch (rgbEncoding) {
            case RGB_565: {
                argbValue = -16777216;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 11, 31), 5) << 16;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 6, 63), 6) << 8;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 0, 31), 5);
                break;
            }
            case RGB_555: {
                argbValue = -16777216;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 10, 31), 5) << 16;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 5, 31), 5) << 8;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 0, 31), 5);
                break;
            }
            case ARGB_1555: {
                argbValue = 255 * RGB16ColorDataType.getFieldValue(value, 15, 1) << 24;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 10, 31), 5) << 16;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 5, 31), 5) << 8;
                argbValue |= RGB16ColorDataType.scaleFieldValue(RGB16ColorDataType.getFieldValue(value, 0, 31), 5);
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing RGB16 Encoding support: " + String.valueOf((Object)rgbEncoding)));
            }
        }
        return new Color(argbValue, true);
    }

    @Override
    protected String getEncodingName(Settings settings) {
        return RGB16EncodingSettingsDefinition.DEF.getRGBEncoding(settings).name();
    }

    @Override
    protected List<AbstractColorDataType.ComponentValue> getComponentValues(MemBuffer buf, Settings settings) {
        byte[] bytes = new byte[LENGTH];
        buf.getBytes(bytes, 0);
        short value = DataConverter.getInstance((boolean)ENDIAN.isBigEndian(settings, buf)).getShort(bytes, 0);
        ArrayList<AbstractColorDataType.ComponentValue> list = new ArrayList<AbstractColorDataType.ComponentValue>();
        RGB16EncodingSettingsDefinition.RGB16Encoding rgbEncoding = RGB16EncodingSettingsDefinition.DEF.getRGBEncoding(settings);
        switch (rgbEncoding) {
            case RGB_565: {
                list.add(new AbstractColorDataType.ComponentValue("R", RGB16ColorDataType.getFieldValue(value, 11, 31), 5));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB16ColorDataType.getFieldValue(value, 6, 63), 6));
                list.add(new AbstractColorDataType.ComponentValue("B", RGB16ColorDataType.getFieldValue(value, 0, 31), 5));
                break;
            }
            case RGB_555: {
                list.add(new AbstractColorDataType.ComponentValue("R", RGB16ColorDataType.getFieldValue(value, 10, 31), 5));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB16ColorDataType.getFieldValue(value, 5, 31), 5));
                list.add(new AbstractColorDataType.ComponentValue("B", RGB16ColorDataType.getFieldValue(value, 0, 31), 5));
                break;
            }
            case ARGB_1555: {
                list.add(new AbstractColorDataType.ComponentValue("A", RGB16ColorDataType.getFieldValue(value, 15, 1), 1));
                list.add(new AbstractColorDataType.ComponentValue("R", RGB16ColorDataType.getFieldValue(value, 10, 31), 5));
                list.add(new AbstractColorDataType.ComponentValue("G", RGB16ColorDataType.getFieldValue(value, 5, 31), 5));
                list.add(new AbstractColorDataType.ComponentValue("B", RGB16ColorDataType.getFieldValue(value, 0, 31), 5));
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing RGB16 Encoding support: " + String.valueOf((Object)rgbEncoding)));
            }
        }
        return list;
    }
}

