/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;

public class DefaultDataType
extends DataTypeImpl {
    public static DefaultDataType dataType = new DefaultDataType();

    private DefaultDataType() {
        super(CategoryPath.ROOT, "undefined", null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "??";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public String getDescription() {
        return "Undefined Byte";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        try {
            int b = buf.getByte(0) & 0xFF;
            String rep = Integer.toHexString(b).toUpperCase() + "h";
            if (rep.length() == 2) {
                rep = "0" + rep;
            }
            if (b > 31 && b < 128) {
                rep = rep + "    " + (char)b;
            }
            return rep;
        }
        catch (MemoryAccessException e) {
            return "??";
        }
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(8, buf.getByte(0));
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        return this;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return this;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        return dt == this;
    }

    @Override
    public void addParent(DataType dt) {
    }

    @Override
    public void removeParent(DataType dt) {
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }
}

