/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ConvertedRecordIterator;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolDatabaseAdapterV3;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

class SymbolDatabaseAdapterV1
extends SymbolDatabaseAdapter {
    private static final int SYMBOL_VERSION = 1;
    private static final int V1_SYMBOL_NAME_COL = 0;
    private static final int V1_SYMBOL_ADDR_COL = 1;
    private static final int V1_SYMBOL_PARENT_COL = 2;
    private static final int V1_SYMBOL_TYPE_COL = 3;
    private static final int V1_SYMBOL_DATA1_COL = 4;
    private static final int V1_SYMBOL_DATA2_COL = 5;
    private static final int V1_SYMBOL_COMMENT_COL = 6;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV1(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap;
        this.symbolTable = handle.getTable("Symbols");
        if (this.symbolTable == null) {
            throw new VersionException("Missing Table: Symbols");
        }
        if (this.symbolTable.getSchema().getVersion() != 1) {
            int version = this.symbolTable.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    DBRecord createSymbolRecord(String name, long namespaceID, Address address, SymbolType symbolType, boolean isPrimary, SourceType source) {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L) {
            return false;
        }
        return this.symbolTable.hasRecord((Field)new LongField(key), 1);
    }

    @Override
    Field[] getSymbolIDs(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L) {
            return Field.EMPTY_ARRAY;
        }
        return this.symbolTable.findRecords((Field)new LongField(key), 1);
    }

    @Override
    DBRecord getSymbolRecord(long symbolID) throws IOException {
        return this.convertV1Record(this.symbolTable.getRecord(symbolID));
    }

    private DBRecord convertV1Record(DBRecord record) {
        Address symbolAddress;
        String defaultName;
        if (record == null) {
            return null;
        }
        DBRecord rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(record.getKey());
        String symbolName = record.getString(0);
        rec.setString(0, symbolName);
        long symbolAddrKey = record.getLongValue(1);
        rec.setLongValue(1, symbolAddrKey);
        long namespaceId = record.getLongValue(2);
        rec.setLongValue(2, namespaceId);
        byte symbolTypeId = record.getByteValue(3);
        rec.setByteValue(3, symbolTypeId);
        SourceType source = SourceType.USER_DEFINED;
        if (symbolTypeId == SymbolType.FUNCTION.getID() && symbolName.equals(defaultName = SymbolUtilities.getDefaultFunctionName(symbolAddress = this.addrMap.decodeAddress(symbolAddrKey)))) {
            source = SourceType.DEFAULT;
        }
        rec.setByteValue(4, (byte)source.ordinal());
        SymbolDatabaseAdapterV3.convertSymbolStringData(symbolTypeId, rec, record.getString(6));
        long dataTypeId = record.getLongValue(4);
        if (dataTypeId != -1L) {
            rec.setLongValue(7, dataTypeId);
        }
        SymbolType type = SymbolType.getSymbolType(symbolTypeId);
        int data2 = record.getIntValue(5);
        if (SymbolType.LABEL.equals(type)) {
            if (data2 == 1) {
                rec.setLongValue(6, symbolAddrKey);
            }
        } else if (SymbolType.PARAMETER.equals(type) || SymbolType.LOCAL_VAR.equals(type)) {
            rec.setIntValue(8, data2);
        }
        if (SymbolType.FUNCTION.equals(type)) {
            rec.setLongValue(6, symbolAddrKey);
        }
        LongField hash = SymbolDatabaseAdapterV1.computeLocatorHash(symbolName, namespaceId, symbolAddrKey);
        rec.setField(5, (Field)hash);
        return rec;
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, forward)));
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, startAddr, forward)));
    }

    @Override
    void updateSymbolRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return new V1ConvertedRecordIterator(this.symbolTable.iterator());
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, start, end, forward)));
    }

    @Override
    RecordIterator getSymbols(AddressSetView set, boolean forward) throws IOException {
        return new V1ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward)));
    }

    @Override
    RecordIterator getPrimarySymbols(AddressSetView set, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward));
        return SymbolDatabaseAdapterV1.getPrimaryFilterRecordIterator((RecordIterator)new V1ConvertedRecordIterator((RecordIterator)it));
    }

    @Override
    DBRecord getPrimarySymbol(Address address) throws IOException {
        RecordIterator it = this.getPrimarySymbols(new AddressSet(address, address), true);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getExternalSymbolsByMemoryAddress(Address extProgAddr) throws IOException {
        return EmptyRecordIterator.INSTANCE;
    }

    @Override
    RecordIterator getExternalSymbolsByOriginalImportName(String extLabel) throws IOException {
        return EmptyRecordIterator.INSTANCE;
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        LongField field = new LongField(id);
        return new V1ConvertedRecordIterator(this.symbolTable.indexIterator(2, (Field)field, (Field)field, true));
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField field = new StringField(name);
        return new V1ConvertedRecordIterator(this.symbolTable.indexIterator(0, (Field)field, (Field)field, true));
    }

    @Override
    RecordIterator scanSymbolsByName(String startName) throws IOException {
        StringField val = new StringField(startName);
        return new V1ConvertedRecordIterator(this.symbolTable.indexIterator(0, (Field)val, null, true));
    }

    @Override
    Table getTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbolsByNameAndNamespace(String name, long id) throws IOException {
        RecordIterator symbolsByName = this.getSymbolsByName(name);
        return SymbolDatabaseAdapterV1.getNameAndNamespaceFilterIterator(name, id, symbolsByName);
    }

    @Override
    DBRecord getSymbolRecord(Address address, String name, long id) throws IOException {
        RecordIterator it = this.getSymbolsByName(name);
        long addressKey = this.addrMap.getKey(address, false);
        RecordIterator filtered = SymbolDatabaseAdapterV1.getNameNamespaceAddressFilterIterator(name, id, addressKey, it);
        if (filtered.hasNext()) {
            return filtered.next();
        }
        return null;
    }

    private class V1ConvertedRecordIterator
    extends ConvertedRecordIterator {
        V1ConvertedRecordIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected DBRecord convertRecord(DBRecord record) {
            return SymbolDatabaseAdapterV1.this.convertV1Record(record);
        }
    }
}

