/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.ToolTipUtils;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DataTypeDropDownSelectionDataModel
implements DropDownTextFieldDataModel<DataType> {
    private final DataTypeManager preferredDtm;
    private final DataTypeManagerService dataTypeService;

    public DataTypeDropDownSelectionDataModel(ServiceProvider serviceProvider) {
        this.preferredDtm = null;
        this.dataTypeService = this.getDataTypeService(serviceProvider);
    }

    public DataTypeDropDownSelectionDataModel(DataTypeManager preferredDtm, DataTypeManagerService dataTypeService) {
        this.preferredDtm = preferredDtm;
        this.dataTypeService = dataTypeService;
    }

    private DataTypeManagerService getDataTypeService(ServiceProvider serviceProvider) {
        DataTypeManagerService service = (DataTypeManagerService)serviceProvider.getService(DataTypeManagerService.class);
        if (service == null) {
            throw new AssertException("Unable to find required DataTypeManagerService.");
        }
        return service;
    }

    public List<DropDownTextFieldDataModel.SearchMode> getSupportedSearchModes() {
        return List.of(DropDownTextFieldDataModel.SearchMode.STARTS_WITH, DropDownTextFieldDataModel.SearchMode.CONTAINS, DropDownTextFieldDataModel.SearchMode.WILDCARD);
    }

    public ListCellRenderer<DataType> getListRenderer() {
        return new DataTypeDropDownRenderer();
    }

    public String getDescription(DataType value) {
        return ToolTipUtils.getToolTipText(value);
    }

    public String getDisplayText(DataType value) {
        return value.getName();
    }

    public List<DataType> getMatchingData(String searchText) {
        throw new UnsupportedOperationException("Method no longer supported.  Instead, call getMatchingData(String, SearchMode)");
    }

    public List<DataType> getMatchingData(String searchText, DropDownTextFieldDataModel.SearchMode mode) {
        if (searchText == null || searchText.length() == 0) {
            return Collections.emptyList();
        }
        if (!this.getSupportedSearchModes().contains(mode)) {
            throw new IllegalArgumentException("Unsupported SearchMode: " + String.valueOf(mode));
        }
        if (mode == DropDownTextFieldDataModel.SearchMode.STARTS_WITH) {
            return this.getMatchDataStartsWith(searchText);
        }
        Pattern p = mode.createPattern(searchText);
        return this.getMatchingDataRegex(p);
    }

    private List<DataType> getMatchDataStartsWith(String searchText) {
        List<DataType> results = DataTypeUtils.getStartsWithMatchingDataTypes(searchText, this.dataTypeService);
        return this.filterDataTypeList(results);
    }

    private List<DataType> getMatchingDataRegex(Pattern p) {
        ArrayList<DataType> results = new ArrayList<DataType>();
        List<DataType> allTypes = this.dataTypeService.getSortedDataTypeList();
        for (DataType dt : allTypes) {
            String name = dt.getName().toLowerCase();
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            results.add(dt);
        }
        return this.filterDataTypeList(results);
    }

    private List<DataType> filterDataTypeList(List<DataType> dtList) {
        HashSet<UniversalID> preferredUids = new HashSet<UniversalID>();
        HashSet<Class> preferredBuiltins = new HashSet<Class>();
        for (DataType dt : dtList) {
            DataType baseDt = DataTypeUtilities.getBaseDataType((DataType)dt);
            if (!this.isFromPreferredDtm(baseDt)) continue;
            if (baseDt instanceof BuiltInDataType) {
                preferredBuiltins.add(baseDt.getClass());
                continue;
            }
            if (baseDt.getUniversalID() == null) continue;
            preferredUids.add(baseDt.getUniversalID());
        }
        ArrayList<DataType> matchingList = new ArrayList<DataType>(dtList.size());
        for (DataType dt : dtList) {
            DataType baseDt;
            if (dt instanceof Array || (baseDt = DataTypeUtilities.getBaseDataType((DataType)dt)) == null || this.preferredDtm != null && !this.isFromPreferredDtm(baseDt) && (baseDt instanceof BuiltInDataType && preferredBuiltins.contains(baseDt.getClass()) || baseDt.getUniversalID() != null && preferredUids.contains(baseDt.getUniversalID()))) continue;
            matchingList.add(dt);
        }
        return matchingList;
    }

    private boolean isFromPreferredDtm(DataType dt) {
        if (dt == null) {
            return false;
        }
        if (this.preferredDtm != null) {
            DataTypeManager dataTypeManager;
            DataTypeManager dataTypeManager2 = this.preferredDtm;
            if (dataTypeManager2 instanceof CompositeViewerDataTypeManager) {
                CompositeViewerDataTypeManager compDtm = (CompositeViewerDataTypeManager)dataTypeManager2;
                dataTypeManager = compDtm.getOriginalDataTypeManager();
            } else {
                dataTypeManager = null;
            }
            DataTypeManager altDtm = dataTypeManager;
            DataTypeManager dtDtm = dt.getDataTypeManager();
            return dtDtm == this.preferredDtm || dtDtm == altDtm;
        }
        return false;
    }

    public int getIndexOfFirstMatchingEntry(List<DataType> data, String text) {
        text = DataTypeUtils.prepareSearchText(text);
        int lastPreferredMatchIndex = -1;
        int i = 0;
        while (i < data.size()) {
            DataType dataType = data.get(i);
            String dataTypeName = dataType.getName();
            if ((dataTypeName = dataTypeName.replaceAll(" ", "")).equals(text)) {
                return i;
            }
            if (!dataTypeName.equalsIgnoreCase(text)) {
                return lastPreferredMatchIndex;
            }
            lastPreferredMatchIndex = i++;
        }
        return -1;
    }

    private class DataTypeDropDownRenderer
    extends GListCellRenderer<DataType> {
        private DataTypeDropDownRenderer() {
        }

        protected String getItemText(DataType dt) {
            DataTypeManager dtm = dt.getDataTypeManager();
            String dtmName = dtm != null ? dtm.getName() : "";
            return dt.getName() + " - " + dtmName + dt.getPathName();
        }

        public Component getListCellRendererComponent(JList<? extends DataType> list, DataType value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
            this.setIcon(DataTypeUtils.getIconForDataType(value, false));
            this.setVerticalAlignment(1);
            return this;
        }
    }
}

