/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.cmd.function.NewFunctionStackAnalysisCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import java.util.Iterator;

class AnalyzeStackRefsAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    AnalyzeStackRefsAction(FunctionPlugin plugin) {
        super("Analyze Function Stack References", plugin.getName());
        this.funcPlugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Analysis", "Analyze Stack"}, null, "Function"));
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Analyze Stack"}, null, "Stack"));
        this.setHelpLocation(new HelpLocation("AutoAnalysisPlugin", "Stack_Analyzer"));
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        Iterator<Function> iter = this.funcPlugin.getFunctions(context);
        if (!iter.hasNext()) {
            String message = "No function at current location";
            ProgramSelection selection = context.getSelection();
            if (selection != null) {
                message = "No functions within current selection";
            }
            this.funcPlugin.getTool().setStatusInfo("Analyze Stack: " + message);
            return;
        }
        AddressSet funcSet = new AddressSet();
        while (iter.hasNext()) {
            Function func = iter.next();
            funcSet.addRange(func.getEntryPoint(), func.getEntryPoint());
        }
        boolean doNewStackAnalysis = true;
        boolean doLocalAnalysis = true;
        boolean doParameterAnalysis = true;
        Program program = context.getProgram();
        Options options = program.getOptions("Analyzers").getOptions("Stack");
        options.registerOption("useNewFunctionStackAnalysis", (Object)doNewStackAnalysis, null, "Use General Stack Reference Propogator (This works best on most processors)");
        options.registerOption("Create Local Variables", (Object)doLocalAnalysis, null, "Create Function Local stack variables and references");
        options.registerOption("Create Param Variables", (Object)doParameterAnalysis, null, "Create Function Parameter stack variables and references");
        doNewStackAnalysis = options.getBoolean("useNewFunctionStackAnalysis", doNewStackAnalysis);
        doLocalAnalysis = options.getBoolean("Create Local Variables", doLocalAnalysis);
        doParameterAnalysis = options.getBoolean("Create Param Variables", doParameterAnalysis);
        NewFunctionStackAnalysisCmd cmd = null;
        cmd = new NewFunctionStackAnalysisCmd((AddressSetView)funcSet, doParameterAnalysis, doLocalAnalysis, true);
        this.funcPlugin.execute(program, cmd);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection()) {
            return true;
        }
        Program program = context.getProgram();
        Address addr = context.getAddress();
        if (program == null || addr == null) {
            return false;
        }
        return program.getListing().getFunctionContaining(addr) != null;
    }
}

