/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint.state;

import ghidra.pcode.emu.taint.state.TaintPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.taint.model.TaintSet;
import ghidra.taint.model.TaintVec;
import ghidra.util.MathUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class TaintSpace {
    protected final AddressSpace space;
    protected final TaintPcodeExecutorStatePiece piece;
    protected final NavigableMap<Long, TaintSet> taints = new TreeMap<Long, TaintSet>(Long::compareUnsigned);

    public TaintSpace(AddressSpace space, TaintPcodeExecutorStatePiece piece) {
        this.space = space;
        this.piece = piece;
    }

    public void set(long offset, TaintVec val, PcodeStateCallbacks cb) {
        for (int i = 0; i < val.length; ++i) {
            TaintSet s = val.get(i);
            this.taints.put(offset + (long)i, s);
        }
        cb.dataWritten((PcodeExecutorStatePiece)this.piece, this.space.getAddress(offset), val.length, (Object)val);
    }

    public void getInto(long offset, TaintVec buf, PcodeStateCallbacks cb) {
        for (int i = 0; i < buf.length; ++i) {
            TaintSet s = (TaintSet)this.taints.get(offset + (long)i);
            if (s == null && cb.readUninitialized((PcodeExecutorStatePiece)this.piece, (AddressSetView)PcodeStateCallbacks.rngSet((AddressSpace)this.space, (long)(offset + (long)i), (int)1)).isEmpty()) {
                s = (TaintSet)this.taints.get(offset + (long)i);
            }
            if (s == null) {
                s = TaintSet.EMPTY;
            }
            buf.set(i, s);
        }
    }

    public TaintVec get(long offset, int size, PcodeStateCallbacks cb) {
        TaintVec vec = new TaintVec(size);
        this.getInto(offset, vec, cb);
        return vec;
    }

    public void clear() {
        this.taints.clear();
    }

    public Map<Register, TaintVec> getRegisterValues(List<Register> registers) {
        HashMap<Register, TaintVec> result = new HashMap<Register, TaintVec>();
        for (Register r : registers) {
            long offset = r.getAddress().getOffset();
            TaintVec vec = new TaintVec(r.getNumBytes());
            for (int i = 0; i < vec.length; ++i) {
                TaintSet s = (TaintSet)this.taints.get(offset + (long)i);
                if (s != null) continue;
            }
            result.put(r, vec);
        }
        return result;
    }

    public Map.Entry<Long, TaintVec> getNextEntry(long offset) {
        Long check = this.taints.ceilingKey(offset);
        if (check == null) {
            return null;
        }
        long end = offset = check.longValue();
        while (this.taints.get(end) != null) {
            ++end;
        }
        TaintVec vec = new TaintVec(MathUtilities.unsignedMin((int)1024, (long)(end - offset)));
        this.getInto(offset, vec, PcodeStateCallbacks.NONE);
        return Map.entry(offset, vec);
    }
}

