/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.features.codecompare.functiongraph.FgComparisonContext;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.features.codecompare.functiongraph.FunctionGraphCodeComparisonView;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;

public class FgToggleSatelliteAction
extends ToggleDockingAction {
    private FunctionGraphCodeComparisonView fgProvider;

    public FgToggleSatelliteAction(FunctionGraphCodeComparisonView fgProvider) {
        super("Display Satellite View", fgProvider.getOwner());
        this.fgProvider = fgProvider;
        this.setPopupMenuData(new MenuData(new String[]{"Display Satellite"}));
        this.setHelpLocation(new HelpLocation("VisualGraph", "Satellite_View"));
    }

    public void actionPerformed(ActionContext context) {
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        boolean visible = this.isSelected();
        leftController.setSatelliteVisible(visible);
        FgDisplay rightDisplay = (FgDisplay)displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        rightController.setSatelliteVisible(visible);
        this.fgProvider.stateChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof FgComparisonContext)) {
            return false;
        }
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController controller = leftDisplay.getController();
        return controller.hasResults();
    }
}

