/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import generic.theme.GColor;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.awt.Color;
import utility.function.Callback;
import utility.function.Dummy;

public class DecompilerCodeComparisonOptions
implements OptionsChangeListener {
    private static final String MATCHING_TOKEN_HIGHLIGHT_KEY = "Focused Token Match Highlight";
    private static final String UNMATCHED_TOKEN_HIGHLIGHT_KEY = "Focused Token Unmatched Highlight";
    private static final String INELIGIBLE_TOKEN_HIGHLIGHT_KEY = "Focused Token Ineligible Highlight";
    private static final String DIFF_HIGHLIGHT_KEY = "Difference Highlight";
    private static final Color DEFAULT_MATCHING_TOKEN_HIGHLIGHT_COLOR = new GColor("color.bg.codecompare.highlight.field.diff.matching");
    private static final Color DEFAULT_UNMATCHED_TOKEN_HIGHLIGHT_COLOR = new GColor("color.bg.codecompare.highlight.field.diff.not.matching");
    private static final Color DEFAULT_INELIGIBLE_TOKEN_HIGHLIGHT_COLOR = new GColor("color.bg.codecompare.highlight.field.diff.other");
    private static final Color DEFAULT_DIFF_HIGHLIGHT_COLOR = new GColor("color.bg.codecompare.highlight.diff");
    private static final String MATCHING_TOKEN_HIGHLIGHT_DESCRIPTION = "Highlight Color for Focused Token and Match";
    private static final String UNMATCHED_TOKEN_HIGHLIGHT_DESCRIPTION = "Highlight Color for a Focused Token with no Match";
    private static final String INELIGIBLE_TOKEN_HIGHLIGHT_DESCRIPTION = "Highlight Color for a Focused Token which is ineligible for a match (e.g., whitespace)";
    private static final String DIFF_HIGHLIGHT_DESCRIPTION = "Highlight Color for Differences";
    private Color matchingTokenHighlight;
    private Color unmatchedTokenHighlight;
    private Color ineligibleTokenHighlight;
    private Color diffHighlight;
    private Callback optionsChangedCallback;
    public static final String OPTIONS_CATEGORY_NAME = "Decompiler Code Comparison";
    public static final String HELP_TOPIC = "FunctionComparison";

    public DecompilerCodeComparisonOptions(PluginTool tool, Callback optionsChangedCallback) {
        this.optionsChangedCallback = Dummy.ifNull((Callback)optionsChangedCallback);
        ToolOptions options = tool.getOptions(OPTIONS_CATEGORY_NAME);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.registerOptions(options);
        this.loadOptions(options);
    }

    public void registerOptions(ToolOptions options) {
        HelpLocation help = new HelpLocation(HELP_TOPIC, "Decompiler Code Comparison Options");
        options.setOptionsHelpLocation(help);
        options.registerThemeColorBinding(MATCHING_TOKEN_HIGHLIGHT_KEY, "color.bg.codecompare.highlight.field.diff.matching", help, MATCHING_TOKEN_HIGHLIGHT_DESCRIPTION);
        options.registerThemeColorBinding(UNMATCHED_TOKEN_HIGHLIGHT_KEY, "color.bg.codecompare.highlight.field.diff.not.matching", help, UNMATCHED_TOKEN_HIGHLIGHT_DESCRIPTION);
        options.registerThemeColorBinding(INELIGIBLE_TOKEN_HIGHLIGHT_KEY, "color.bg.codecompare.highlight.field.diff.other", help, INELIGIBLE_TOKEN_HIGHLIGHT_DESCRIPTION);
        options.registerThemeColorBinding(DIFF_HIGHLIGHT_KEY, "color.bg.codecompare.highlight.diff", help, DIFF_HIGHLIGHT_DESCRIPTION);
    }

    public void loadOptions(ToolOptions options) {
        this.matchingTokenHighlight = options.getColor(MATCHING_TOKEN_HIGHLIGHT_KEY, DEFAULT_MATCHING_TOKEN_HIGHLIGHT_COLOR);
        this.unmatchedTokenHighlight = options.getColor(UNMATCHED_TOKEN_HIGHLIGHT_KEY, DEFAULT_UNMATCHED_TOKEN_HIGHLIGHT_COLOR);
        this.ineligibleTokenHighlight = options.getColor(INELIGIBLE_TOKEN_HIGHLIGHT_KEY, DEFAULT_INELIGIBLE_TOKEN_HIGHLIGHT_COLOR);
        this.diffHighlight = options.getColor(DIFF_HIGHLIGHT_KEY, DEFAULT_DIFF_HIGHLIGHT_COLOR);
    }

    public Color getFocusedTokenMatchHighlightColor() {
        return this.matchingTokenHighlight;
    }

    public Color getFocusedTokenUnmatchedHighlightColor() {
        return this.unmatchedTokenHighlight;
    }

    public Color getFocusedTokenIneligibleHighlightColor() {
        return this.ineligibleTokenHighlight;
    }

    public Color getDiffHighlightColor() {
        return this.diffHighlight;
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        this.loadOptions(options);
        this.optionsChangedCallback.call();
    }

    public void dispose(PluginTool tool) {
        ToolOptions options = tool.getOptions(OPTIONS_CATEGORY_NAME);
        options.removeOptionsChangeListener((OptionsChangeListener)this);
    }
}

