/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.app.plugin.core.debug.client.tracermi.RmiTrace;
import ghidra.util.LockHold;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RmiTransaction
implements AutoCloseable {
    private RmiTrace trace;
    private int id;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean closed = false;

    public RmiTransaction(RmiTrace trace, int id) {
        this.trace = trace;
        this.id = id;
    }

    public void commit() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.trace.endTx(this.id, false);
    }

    public void abort() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.trace.endTx(this.id, true);
    }

    @Override
    public void close() {
        this.commit();
    }
}

