/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.app.plugin.core.debug.client.tracermi.RmiMethods;
import ghidra.app.plugin.core.debug.client.tracermi.RmiRemoteMethodParameter;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObject;
import ghidra.trace.model.target.iface.TraceMethod;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class RmiRemoteMethod {
    private final SchemaContext schemaContext;
    private final String name;
    private final String action;
    private final String display;
    private final String description;
    private final String okText;
    private final String icon;
    private final RmiRemoteMethodParameter[] params;
    private final TraceObjectSchema schema;
    private final RmiMethods instance;
    private final Method m;

    public RmiRemoteMethod(SchemaContext schemaContext, String name, String action, String display, String description, String okText, String icon, TraceObjectSchema schema, RmiMethods instance, Method m) {
        this.schemaContext = schemaContext;
        this.name = name;
        this.action = action;
        this.display = display;
        this.description = description;
        this.okText = okText;
        this.icon = icon;
        this.params = new RmiRemoteMethodParameter[m.getParameterCount()];
        this.schema = schema;
        this.instance = instance;
        this.m = m;
        int i = 0;
        for (Parameter p : m.getParameters()) {
            TraceMethod.ParameterDescription desc = TraceMethod.ParameterDescription.annotated((Parameter)p);
            Object pschema = desc.type != RmiTraceObject.class ? PrimitiveTraceObjectSchema.schemaForPrimitive((Class)desc.type) : schemaContext.getSchema(new TraceObjectSchema.SchemaName(desc.schema));
            this.params[i++] = new RmiRemoteMethodParameter(desc.name, (TraceObjectSchema)pschema, desc.required, desc.defaultValue, desc.display, desc.description);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOkText() {
        return this.okText;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getAction() {
        return this.action;
    }

    public String getDisplay() {
        return this.display;
    }

    public RmiRemoteMethodParameter[] getParameters() {
        return this.params;
    }

    public Method getMethod() {
        return this.m;
    }

    public TraceObjectSchema getSchema() {
        return this.schema;
    }

    public RmiMethods getContainer() {
        return this.instance;
    }
}

