/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.widgets.OptionDialogBuilder;
import java.awt.Component;

class FileCountStatistics {
    private int fileCount;
    private int readOnlySkipped;
    private int generalFailure;
    private int fileInUse;
    private int versionedDeclined;
    private int checkedOutVersioned;
    private int deleted;

    FileCountStatistics(int fileCount) {
        this.fileCount = fileCount;
    }

    public void incrementDeleted() {
        ++this.deleted;
    }

    public int getTotalDeleted() {
        return this.deleted;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void incrementFileCount(int size) {
        this.fileCount += size;
    }

    public void incrementReadOnly() {
        ++this.readOnlySkipped;
    }

    public void incrementGeneralFailure() {
        ++this.generalFailure;
    }

    public void incrementFileInUse() {
        ++this.fileInUse;
    }

    public void incrementVersioned() {
        ++this.versionedDeclined;
    }

    public void incrementCheckedOutVersioned() {
        ++this.checkedOutVersioned;
    }

    public void showReport(Component parent) {
        if (this.fileCount == 1 && this.getTotalProcessed() == 1) {
            return;
        }
        if (this.deleted == this.fileCount) {
            return;
        }
        String message = this.buildReportMessage();
        OptionDialogBuilder builder = new OptionDialogBuilder("Delete Files Summary", message);
        builder.setMessageType(1);
        builder.show(parent);
    }

    private String buildReportMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append(this.deleted).append(" file(s) deleted!");
        if (this.getTotalNotDeleted() > 0) {
            builder.append("<br><br>Files not deleted:<br>");
            builder.append("<table style='margin-left: 20pt;'>");
            if (this.fileInUse > 0) {
                builder.append("<tr><td>In Use: </td><td>").append(this.fileInUse).append("</td></tr>");
            }
            if (this.versionedDeclined > 0) {
                builder.append("<tr><td>   Versioned: </td><td>").append(this.versionedDeclined).append("</td></tr>");
            }
            if (this.checkedOutVersioned > 0) {
                builder.append("<tr><td>Checked-out: </td><td>").append(this.checkedOutVersioned).append("</td></tr>");
            }
            if (this.readOnlySkipped > 0) {
                builder.append("<tr><td>Read only: </td><td>").append(this.readOnlySkipped).append("</td></tr>");
            }
            if (this.generalFailure > 0) {
                builder.append("<tr><td>Other: </td><td>").append(this.generalFailure).append("</td></tr>");
            }
            builder.append("</table>");
        }
        return builder.toString();
    }

    private int getTotalProcessed() {
        return this.readOnlySkipped + this.generalFailure + this.fileInUse + this.versionedDeclined + this.checkedOutVersioned + this.deleted;
    }

    private int getTotalNotDeleted() {
        return this.getTotalProcessed() - this.deleted;
    }
}

