/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeNode;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.DomainFolderRootNode;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.ProjectData;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.util.Swing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

class ChangeManager
implements DomainFolderChangeListener,
TreeModelListener {
    private DomainFolderRootNode root;
    private ProjectData projectData;
    private ProjectDataTreePanel treePanel;
    private DataTree tree;
    private LinkedTreeNode linkTreeRoot = new LinkedTreeNode(null, null);
    private boolean skipLinkUpdate = false;
    private HashSet<String> refreshedTrackingSet;

    ChangeManager(ProjectDataTreePanel treePanel) {
        this.treePanel = treePanel;
        this.projectData = treePanel.getProjectData();
        this.tree = treePanel.getDataTree();
        this.root = (DomainFolderRootNode)this.tree.getModelRoot();
        if (this.projectData != null) {
            this.projectData.addDomainFolderChangeListener(this);
            this.tree.addGTModelListener(this);
        }
    }

    void dispose() {
        if (this.projectData != null) {
            this.projectData.removeDomainFolderChangeListener(this);
            this.tree.removeGTModelListener(this);
            this.projectData = null;
        }
    }

    @Override
    public void domainFileAdded(DomainFile file) {
        boolean isFolderLink = file.isLink() && file.getLinkInfo().isFolderLink();
        String fileName = file.getName();
        DomainFolder parentFolder = file.getParent();
        this.updateLinkedContent(parentFolder.getPathname(), p -> this.addFileNode((DataTreeNode)p, fileName, isFolderLink), ltn -> ltn.refreshLinks(fileName));
        DomainFolderNode folderNode = this.findDomainFolderNode(parentFolder, true);
        if (folderNode != null && folderNode.isLoaded()) {
            this.addFileNode(folderNode, fileName, isFolderLink);
        }
    }

    @Override
    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.updateLinkedContent(parent.getPathname(), null, ltn -> ltn.refreshLinks(name));
        DomainFolderNode folderNode = this.findDomainFolderNode(parent, true);
        if (folderNode != null) {
            this.updateChildren(folderNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void domainFileRenamed(DomainFile file, String oldName) {
        boolean isFolderLink = file.isLink() && file.getLinkInfo().isFolderLink();
        this.updateLinkedContent(file.getParent().getPathname(), p -> {
            this.updateChildren((DataTreeNode)p);
            this.addFileNode((DataTreeNode)p, file.getName(), isFolderLink);
        }, ltn -> {
            ltn.refreshLinks(oldName);
            ltn.refreshLinks(file.getName());
        });
        DomainFolder parent = file.getParent();
        this.skipLinkUpdate = true;
        try {
            this.domainFileRemoved(parent, oldName, file.getFileID());
            this.domainFileAdded(file);
        }
        finally {
            this.skipLinkUpdate = false;
        }
    }

    @Override
    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        this.domainFileRemoved(oldParent, oldName, null);
        this.domainFileAdded(file);
    }

    @Override
    public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
        LinkFileInfo linkInfo = file.getLinkInfo();
        boolean isFolderLink = linkInfo != null && linkInfo.isFolderLink();
        DomainFolder parentFolder = file.getParent();
        this.updateLinkedContent(parentFolder.getPathname(), fn -> {
            if (fn.isLoaded()) {
                DataTreeNode.NodeType type = isFolderLink ? DataTreeNode.NodeType.FOLDER_LINK : DataTreeNode.NodeType.FILE;
                DomainFileNode fileNode = (DomainFileNode)fn.getChild(file.getName(), type);
                if (fileNode != null) {
                    fileNode.refresh();
                }
            }
        }, ltn -> ltn.refreshLinks(file.getName()));
        DomainFileNode fileNode = this.findDomainFileNode(file, true);
        if (fileNode != null) {
            fileNode.refresh();
        }
        this.treePanel.contextChanged();
    }

    @Override
    public void domainFolderAdded(DomainFolder folder) {
        String folderName = folder.getName();
        DomainFolder parentFolder = folder.getParent();
        this.updateLinkedContent(parentFolder.getPathname(), p -> this.addFolderNode((DataTreeNode)p, folderName), ltn -> ltn.refreshLinks(folderName));
        DomainFolderNode folderNode = this.findDomainFolderNode(parentFolder, true);
        if (folderNode != null && folderNode.isLoaded()) {
            this.addFolderNode(folderNode, folderName);
        }
    }

    @Override
    public void domainFolderRemoved(DomainFolder parent, String name) {
        this.updateLinkedContent(parent.getPathname(), null, ltn -> ltn.refreshLinks(name));
        DomainFolderNode folderNode = this.findDomainFolderNode(parent, true);
        if (folderNode != null) {
            this.updateChildren(folderNode);
        }
    }

    @Override
    public void domainFolderRenamed(DomainFolder folder, String oldName) {
        this.domainFolderMoved(folder.getParent().getPathname(), oldName, folder);
        this.skipLinkUpdate = true;
        try {
            this.domainFolderRemoved(folder.getParent(), oldName);
            this.domainFolderAdded(folder);
        }
        finally {
            this.skipLinkUpdate = false;
        }
    }

    @Override
    public void domainFolderMoved(DomainFolder folder, DomainFolder oldParent) {
        this.domainFolderMoved(oldParent.getPathname(), folder.getName(), folder);
        this.skipLinkUpdate = true;
        try {
            this.domainFolderRemoved(oldParent, folder.getName());
            this.domainFolderAdded(folder);
        }
        finally {
            this.skipLinkUpdate = false;
        }
    }

    @Override
    public void domainFolderSetActive(DomainFolder folder) {
        DomainFolderNode folderNode = this.findDomainFolderNode(folder, false);
        if (folderNode != null) {
            this.tree.setSelectedNode((GTreeNode)folderNode);
        }
    }

    private void domainFolderMoved(String oldParentPath, String oldName, DomainFolder folder) {
        String oldFolderPathname = LocalFileSystem.getPath((String)oldParentPath, (String)oldName);
        for (DomainFolder childFolder : folder.getFolders()) {
            this.domainFolderMoved(oldFolderPathname, childFolder.getName(), childFolder);
        }
        this.updateLinkedContent(oldParentPath, null, ltn -> ltn.refreshLinks(oldName));
        String newName = folder.getName();
        this.updateLinkedContent(folder.getParent().getPathname(), p -> this.addFolderNode((DataTreeNode)p, newName), ltn -> ltn.refreshLinks(newName));
    }

    private DomainFolder getDomainFolder(DataTreeNode node) {
        DomainFolder folder = null;
        if (node instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)node;
            folder = fileNode.getLinkedFolder();
        } else if (node instanceof DomainFolderNode) {
            DomainFolderNode folderNode = (DomainFolderNode)node;
            folder = folderNode.getDomainFolder();
        }
        return folder;
    }

    private void addFileNode(DataTreeNode node, String fileName, boolean isFolderLink) {
        DomainFile file;
        if (node.isLeaf() || !node.isLoaded()) {
            return;
        }
        DomainFileNode fileNode = (DomainFileNode)node.getChild(fileName, isFolderLink ? DataTreeNode.NodeType.FOLDER_LINK : DataTreeNode.NodeType.FILE);
        if (fileNode != null) {
            this.domainFileStatusChanged(fileNode.getDomainFile(), false);
            return;
        }
        DomainFolder folder = this.getDomainFolder(node);
        if (folder != null && (file = folder.getFile(fileName)) != null) {
            DomainFileNode newNode = new DomainFileNode(file, this.root.getDomainFileFilter());
            node.addNode((GTreeNode)newNode);
        }
    }

    private void addFolderNode(DataTreeNode node, String folderName) {
        DomainFolder f;
        if (node.isLeaf() || !node.isLoaded()) {
            return;
        }
        if (node.getChild(folderName, DataTreeNode.NodeType.FOLDER) != null) {
            return;
        }
        DomainFolder folder = this.getDomainFolder(node);
        if (folder != null && (f = folder.getFolder(folderName)) != null) {
            DomainFolderNode newNode = new DomainFolderNode(f, this.root.getDomainFileFilter());
            node.addNode((GTreeNode)newNode);
        }
    }

    private void getFolderPath(DomainFolder df, List<String> list) {
        DomainFolder parent = df.getParent();
        if (parent != null) {
            this.getFolderPath(parent, list);
            list.add(df.getName());
        }
    }

    private DomainFolderNode findDomainFolderNode(DomainFolder df, boolean lazy) {
        ArrayList<String> folderPath = new ArrayList<String>();
        this.getFolderPath(df, folderPath);
        return this.findDomainFolderNode(folderPath, lazy);
    }

    private DomainFolderNode findDomainFolderNode(List<String> folderPath, boolean lazy) {
        DomainFolderNode folderNode = this.root;
        for (String name : folderPath) {
            if (lazy && !folderNode.isLoaded()) {
                return null;
            }
            if ((folderNode = (DomainFolderNode)folderNode.getChild(name, DataTreeNode.NodeType.FOLDER)) != null) continue;
            return null;
        }
        return folderNode;
    }

    private DomainFileNode findDomainFileNode(DomainFile domainFile, boolean lazy) {
        DomainFolderNode folderNode = this.findDomainFolderNode(domainFile.getParent(), lazy);
        if (folderNode == null) {
            return null;
        }
        if (lazy && !folderNode.isLoaded()) {
            return null;
        }
        boolean isFolderLink = domainFile.isLink() && domainFile.getLinkInfo().isFolderLink();
        return (DomainFileNode)folderNode.getChild(domainFile.getName(), isFolderLink ? DataTreeNode.NodeType.FOLDER_LINK : DataTreeNode.NodeType.FILE);
    }

    private void updateChildren(DataTreeNode parentNode) {
        if (!parentNode.isLoaded()) {
            return;
        }
        DomainFolder folder = null;
        if (parentNode instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)parentNode;
            folder = fileNode.getLinkedFolder();
        } else if (parentNode instanceof DomainFolderNode) {
            DomainFolderNode folderNode = (DomainFolderNode)parentNode;
            folder = folderNode.getDomainFolder();
        }
        if (folder == null) {
            return;
        }
        List children = parentNode.getChildren();
        for (GTreeNode child : children) {
            if (child instanceof DomainFileNode) {
                if (folder.getFile(child.getName()) != null) continue;
                parentNode.removeNode(child);
                continue;
            }
            if (!(child instanceof DomainFolderNode) || folder.getFolder(child.getName()) != null) continue;
            parentNode.removeNode(child);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        TreePath treePath = e.getTreePath();
        Object[] changedChildren = e.getChildren();
        if (changedChildren != null) {
            for (Object child : changedChildren) {
                this.treeNodeChanged(child, true);
            }
        } else if (treePath != null) {
            this.treeNodeChanged(treePath.getLastPathComponent(), true);
        }
    }

    private void treeNodeChanged(Object treeNode, boolean processLoadedChildren) {
        if (!(treeNode instanceof DataTreeNode)) {
            return;
        }
        DataTreeNode dataTreeNode = (DataTreeNode)treeNode;
        if (treeNode instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)treeNode;
            this.addLinkFile(fileNode);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        Object[] changedChildren = e.getChildren();
        if (changedChildren != null) {
            for (Object child : changedChildren) {
                this.treeNodeChanged(child, false);
            }
        } else {
            this.treeNodeChanged(e.getTreePath().getLastPathComponent(), false);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    private void addLoadedChildren(DataTreeNode node) {
        if (!node.isLoaded()) {
            return;
        }
        for (GTreeNode child : node.getChildren()) {
            if (!(child instanceof DomainFileNode)) continue;
            DomainFileNode fileNode = (DomainFileNode)child;
            this.addLinkFile(fileNode);
        }
    }

    void addLinkFile(DomainFileNode domainFileNode) {
        DomainFile file = domainFileNode.getDomainFile();
        LinkFileInfo linkInfo = file.getLinkInfo();
        if (linkInfo == null || linkInfo.isExternalLink()) {
            return;
        }
        try {
            String linkPath = LinkHandler.getAbsoluteLinkPath(file);
            if (linkPath == null) {
                return;
            }
            boolean isFolderLink = linkInfo.isFolderLink();
            String[] pathElements = linkPath.split("/");
            int lastFolderIndex = pathElements.length - 1;
            if (!isFolderLink) {
                --lastFolderIndex;
            }
            LinkedTreeNode folderLinkNode = this.linkTreeRoot;
            for (int i = 1; i <= lastFolderIndex; ++i) {
                folderLinkNode = folderLinkNode.addFolder(pathElements[i]);
            }
            if (isFolderLink) {
                folderLinkNode.addLinkedFolder(domainFileNode);
                this.addLoadedChildren(domainFileNode);
            } else {
                folderLinkNode.addLinkedFile(pathElements[lastFolderIndex + 1], domainFileNode);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkedContent(String parentFolderPath, Consumer<DataTreeNode> folderNodeConsumer, Consumer<LinkedTreeNode> linkNodeConsumer) {
        if (!Swing.isSwingThread()) {
            throw new RuntimeException("Listener and all node updates must operate in Swing thread");
        }
        if (this.skipLinkUpdate) {
            return;
        }
        boolean clearRefreshedTrackingSet = false;
        if (this.refreshedTrackingSet == null) {
            this.refreshedTrackingSet = new HashSet();
            clearRefreshedTrackingSet = true;
        }
        try {
            String[] pathElements = parentFolderPath.split("/");
            LinkedTreeNode folderLinkNode = this.linkTreeRoot;
            folderLinkNode.updateLinkedContent(pathElements, 1, folderNodeConsumer);
            for (int i = 1; i < pathElements.length; ++i) {
                folderLinkNode = folderLinkNode.folderMap.get(pathElements[i]);
                if (folderLinkNode == null) {
                    return;
                }
                folderLinkNode.updateLinkedContent(pathElements, i + 1, folderNodeConsumer);
            }
            if (linkNodeConsumer != null) {
                linkNodeConsumer.accept(folderLinkNode);
            }
        }
        finally {
            if (clearRefreshedTrackingSet) {
                this.refreshedTrackingSet = null;
            }
        }
    }

    private class LinkedTreeNode {
        private final LinkedTreeNode parent;
        private final String name;
        private Map<String, LinkedTreeNode> folderMap = new HashMap<String, LinkedTreeNode>();
        private Set<DomainFileNode> folderLinks = new HashSet<DomainFileNode>();
        private Map<String, Set<DomainFileNode>> linkedFilesMap = new HashMap<String, Set<DomainFileNode>>();

        LinkedTreeNode(LinkedTreeNode parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        private void updateLinkedContent(String[] pathElements, int subFolderPathIndex, Consumer<DataTreeNode> folderNodeConsumer) {
            boolean updateThisNode = subFolderPathIndex >= pathElements.length;
            Iterator<DomainFileNode> folderLinkIter = this.folderLinks.iterator();
            while (folderLinkIter.hasNext()) {
                DomainFileNode folderLink = folderLinkIter.next();
                if (folderLink.getParent() == null) {
                    folderLinkIter.remove();
                }
                if (!folderLink.isLoaded()) continue;
                if (updateThisNode) {
                    if (folderNodeConsumer != null) {
                        folderNodeConsumer.accept(folderLink);
                        continue;
                    }
                    ChangeManager.this.updateChildren(folderLink);
                    continue;
                }
                DomainFolderNode folderNode = null;
                for (int ix = subFolderPathIndex; ix < pathElements.length; ++ix) {
                    folderNode = (DomainFolderNode)folderLink.getChild(pathElements[ix], DataTreeNode.NodeType.FOLDER);
                    if (folderNode != null && folderNode.isLoaded()) continue;
                    folderNode = null;
                    break;
                }
                if (folderNode == null) continue;
                if (folderNodeConsumer != null) {
                    folderNodeConsumer.accept(folderNode);
                    continue;
                }
                ChangeManager.this.updateChildren(folderNode);
            }
        }

        private void refreshLinks(String childName) {
            String childPathName = LocalFileSystem.getPath((String)this.getPathname(), (String)childName);
            if (!ChangeManager.this.refreshedTrackingSet.add(childPathName)) {
                return;
            }
            if (this.refreshFileLinks(childName) || this.refreshFolderLinks(childName)) {
                this.purgeFolderWithoutLinks();
            }
        }

        private boolean refreshFolderLinks(String folderName) {
            LinkedTreeNode linkedTreeNode = this.folderMap.get(folderName);
            if (linkedTreeNode != null) {
                this.refresh(linkedTreeNode.folderLinks);
                boolean removed = linkedTreeNode.folderLinks.isEmpty();
                Collection<Set<DomainFileNode>> linkedFileSets = linkedTreeNode.linkedFilesMap.values();
                if (!linkedFileSets.isEmpty()) {
                    Iterator<Set<DomainFileNode>> iterator = linkedFileSets.iterator();
                    while (iterator.hasNext()) {
                        Set<DomainFileNode> linkFileSet = iterator.next();
                        this.refresh(linkFileSet);
                        if (!linkFileSet.isEmpty()) continue;
                        iterator.remove();
                        removed = true;
                    }
                }
                return removed;
            }
            return false;
        }

        private boolean refreshFileLinks(String fileName) {
            Set<DomainFileNode> linkFiles = this.linkedFilesMap.get(fileName);
            if (linkFiles != null) {
                this.refresh(linkFiles);
                if (linkFiles.isEmpty()) {
                    this.linkedFilesMap.remove(fileName);
                    return true;
                }
            }
            return false;
        }

        private LinkedTreeNode addFolder(String folderName) {
            return this.folderMap.computeIfAbsent(folderName, n -> new LinkedTreeNode(this, (String)n));
        }

        private boolean addLinkedFolder(DomainFileNode folderLink) {
            return this.folderLinks.add(folderLink);
        }

        private void addLinkedFile(String fileName, DomainFileNode fileLink) {
            Set fileLinks = this.linkedFilesMap.computeIfAbsent(fileName, n -> new HashSet());
            fileLinks.add(fileLink);
        }

        private void purgeFolderWithoutLinks() {
            if (this.parent != null && this.folderMap.isEmpty() && this.folderLinks.isEmpty() && this.linkedFilesMap.isEmpty()) {
                this.parent.folderMap.remove(this.name);
                this.parent.purgeFolderWithoutLinks();
            }
        }

        private void refresh(Set<DomainFileNode> linkFiles) {
            Iterator<DomainFileNode> linkFileIter = linkFiles.iterator();
            while (linkFileIter.hasNext()) {
                DomainFileNode fileLink = linkFileIter.next();
                if (fileLink.getParent() == null || !fileLink.getDomainFile().isLink()) {
                    linkFileIter.remove();
                    continue;
                }
                fileLink.refresh();
                GTreeNode linkParent = fileLink.getParent();
                if (!(linkParent instanceof DomainFolderNode)) continue;
                DomainFolderNode linkParentNode = (DomainFolderNode)linkParent;
                ChangeManager.this.updateLinkedContent(linkParentNode.getPathname(), fn -> {}, (LinkedTreeNode ltn) -> ltn.refreshLinks(fileLink.getName()));
            }
        }

        private String getPathname() {
            if (this.parent == null) {
                return "/";
            }
            return this.parent.getPathname() + this.name + "/";
        }

        public String toString() {
            return this.getPathname();
        }
    }
}

