/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import ghidra.util.task.CancelOnlyWrappingTaskMonitor;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import utilities.util.FileUtilities;

public class ArchiveExtractor {
    public static void explode(File baseDir, File archiveFile, TaskMonitor monitor) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(archiveFile);
        monitor.setIndeterminate(true);
        int count = ArchiveExtractor.getEntryCount(zipFile);
        monitor.initialize((long)count);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String path = entry.getName();
            File outputFile = new File(baseDir, path);
            InputStream inputStream = zipFile.getInputStream(entry);
            FileUtilities.copyStreamToFile((InputStream)inputStream, (File)outputFile, (boolean)false, (TaskMonitor)new CancelOnlyWrappingTaskMonitor(monitor));
            monitor.incrementProgress(1L);
            if (!monitor.isCancelled()) continue;
            break;
        }
        zipFile.close();
    }

    private static int getEntryCount(ZipFile zipFile) {
        int count = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            entries.nextElement();
            ++count;
        }
        return count;
    }
}

