/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.sigar;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

class LibraryExtractor {
    private static final int BUFFER_LENGTH = 4096;
    private final File libDir;
    private final String libDirName;

    public LibraryExtractor(String libDirName) {
        this.libDir = new File(System.getProperty("java.io.tmpdir") + File.separator + libDirName);
        this.libDirName = libDirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFile(String libFileName) throws IOException {
        block8: {
            this.libDir.mkdirs();
            File libFile = new File(this.libDir, libFileName);
            libFile.createNewFile();
            URL libUrl = LibraryExtractor.class.getClassLoader().getResource(this.libDirName + "/" + libFileName);
            byte[] libHash = LibraryExtractor.hash(libUrl);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(libFile, "r");
                byte[] libFileHash = LibraryExtractor.hash(raf);
                if (Arrays.equals(libHash, libFileHash)) break block8;
                raf.close();
                raf = new RandomAccessFile(libFile, "rw");
                FileLock lock = raf.getChannel().lock();
                try {
                    libFileHash = LibraryExtractor.hash(raf);
                    if (!Arrays.equals(libHash, libFileHash)) {
                        LibraryExtractor.copy(libUrl, raf);
                    }
                }
                finally {
                    lock.release();
                }
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
    }

    public String getLibPath() {
        return this.libDir.getAbsolutePath();
    }

    public String getFilePath(String libFileName) {
        return new File(this.libDir, libFileName).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] hash(URL url) throws IOException {
        byte[] buffer = new byte[4096];
        MessageDigest digest = LibraryExtractor.newMessageDigest();
        InputStream input = null;
        int read = 0;
        try {
            input = url.openStream();
            while ((read = input.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
        }
        finally {
            LibraryExtractor.safeClose(input);
        }
        return digest.digest();
    }

    private static byte[] hash(RandomAccessFile file) throws IOException {
        byte[] buffer = null;
        MessageDigest digest = LibraryExtractor.newMessageDigest();
        long pointer = 0L;
        file.seek(pointer);
        long length = file.length();
        while ((pointer = file.getFilePointer()) < length) {
            int bufferLength;
            int n = bufferLength = 4096L > length - pointer ? (int)(length - pointer) : 4096;
            if (buffer == null || buffer.length != bufferLength) {
                buffer = new byte[bufferLength];
            }
            file.read(buffer);
            digest.update(buffer);
        }
        return digest.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL url, RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[4096];
        InputStream input = null;
        file.seek(0L);
        file.setLength(0L);
        try {
            int length;
            input = url.openStream();
            while ((length = input.read(buffer)) > 0) {
                file.write(buffer, 0, length);
            }
        }
        finally {
            LibraryExtractor.safeClose(input);
        }
    }

    private static MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void safeClose(Closeable file) {
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

