/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.FontValue;
import generic.theme.GThemeValueMap;
import generic.theme.ThemeEvent;

public class FontChangedThemeEvent
extends ThemeEvent {
    private final FontValue font;
    private final GThemeValueMap values;

    public FontChangedThemeEvent(GThemeValueMap values, FontValue font) {
        this.values = values;
        this.font = font;
    }

    @Override
    public boolean isFontChanged(String id) {
        if (id.equals(this.font.getId())) {
            return true;
        }
        FontValue testValue = this.values.getFont(id);
        if (testValue == null) {
            return false;
        }
        return testValue.inheritsFrom(this.font.getId(), this.values);
    }

    @Override
    public boolean hasAnyFontChanged() {
        return true;
    }
}

