/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization.mouse;

import ghidra.graph.visualization.mouse.JgtUtils;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.jungrapht.visualization.selection.MutableSelectedState;

public abstract class AbstractJgtGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected boolean isHandlingMouseEvents;
    protected V selectedVertex;
    protected E selectedEdge;

    public VisualizationViewer<V, E> getViewer(MouseEvent e) {
        VisualizationViewer<V, E> viewer = this.getGraphViewer(e);
        return viewer;
    }

    public VisualizationViewer<V, E> getGraphViewer(MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        if (viewer instanceof SatelliteVisualizationViewer) {
            return ((SatelliteVisualizationViewer)viewer).getMaster();
        }
        return viewer;
    }

    public SatelliteVisualizationViewer<V, E> getSatelliteGraphViewer(MouseEvent e) {
        VisualizationViewer viewer = (VisualizationViewer)e.getSource();
        if (viewer instanceof SatelliteVisualizationViewer) {
            return (SatelliteVisualizationViewer)viewer;
        }
        throw new IllegalStateException("Do not have a satellite GraphViewer");
    }

    public void dispose() {
    }

    protected boolean checkForVertex(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            this.selectedVertex = null;
            return false;
        }
        VisualizationViewer<V, E> vv = this.getViewer(e);
        this.selectedVertex = JgtUtils.getVertex(e, vv);
        if (this.selectedVertex == null) {
            return false;
        }
        e.consume();
        return true;
    }

    protected boolean checkForEdge(MouseEvent e) {
        if (!this.checkModifiers(e) || this.isOverVertex(e)) {
            this.selectedEdge = null;
            return false;
        }
        VisualizationViewer<V, E> vv = this.getViewer(e);
        this.selectedEdge = JgtUtils.getEdge(e, vv);
        if (this.selectedEdge == null) {
            return false;
        }
        e.consume();
        this.isHandlingMouseEvents = true;
        return true;
    }

    protected boolean selectVertex(V vertex, VisualizationViewer<V, E> viewer) {
        MutableSelectedState selectedVertexState = viewer.getSelectedVertexState();
        if (selectedVertexState == null) {
            return false;
        }
        selectedVertexState.isSelected(vertex);
        if (!selectedVertexState.isSelected(vertex)) {
            selectedVertexState.clear();
            selectedVertexState.select(vertex, true);
        }
        return true;
    }

    protected boolean selectEdge(E edge, VisualizationViewer<V, E> viewer) {
        MutableSelectedState selectedVertexState = viewer.getSelectedEdgeState();
        if (selectedVertexState == null) {
            return false;
        }
        selectedVertexState.isSelected(edge);
        if (!selectedVertexState.isSelected(edge)) {
            selectedVertexState.clear();
            selectedVertexState.select(edge, true);
        }
        return true;
    }

    protected boolean isOverVertex(MouseEvent e) {
        return this.getVertex(e) != null;
    }

    protected V getVertex(MouseEvent e) {
        VisualizationViewer<V, E> viewer = this.getViewer(e);
        return JgtUtils.getVertex(e, viewer);
    }

    protected boolean isOverEdge(MouseEvent e) {
        VisualizationViewer<V, E> viewer = this.getViewer(e);
        E edge = JgtUtils.getEdge(e, viewer);
        if (edge == null) {
            return false;
        }
        return !this.isOverVertex(e);
    }

    protected void installCursor(Cursor newCursor, MouseEvent e) {
        VisualizationViewer<V, E> viewer = this.getViewer(e);
        viewer.setCursor(newCursor);
    }

    protected boolean shouldShowCursor(MouseEvent e) {
        return this.isOverVertex(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        e.consume();
        this.resetState();
    }

    protected void resetState() {
        this.isHandlingMouseEvents = false;
        this.selectedVertex = null;
        this.selectedEdge = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        e.consume();
        this.resetState();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
        if (this.shouldShowCursor(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isHandlingMouseEvents) {
            e.consume();
        }
        if (this.shouldShowCursor(e)) {
            this.installCursor(this.cursor, e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.shouldShowCursor(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.installCursor(Cursor.getPredefinedCursor(0), e);
    }
}

