/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import docking.options.editor.GhidraColorChooser;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractSetSecondaryHighlightAction;
import java.awt.Color;
import java.util.List;

public class SetSecondaryHighlightColorChooserAction
extends AbstractSetSecondaryHighlightAction {
    public static String NAME = "Set Secondary Highlight With Color";

    public SetSecondaryHighlightColorChooserAction() {
        super(NAME);
        this.setPopupMenuData(new MenuData(new String[]{"Secondary Highlight", "Set Highlight..."}, "Decompile"));
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ClangToken token = context.getTokenAtCursor();
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlightColors colors = panel.getSecondaryHighlightColors();
        List<Color> recentColors = colors.getRecentColors();
        String name = token.getText();
        Color currentColor = colors.getColor(name);
        GhidraColorChooser chooser = new GhidraColorChooser(currentColor);
        chooser.setColorHistory(recentColors);
        chooser.setActiveTab("RGB");
        Color colorChoice = chooser.showDialog(null);
        if (colorChoice == null) {
            return;
        }
        colors.setColor(name, colorChoice);
        panel.addSecondaryHighlight(token, colorChoice);
    }
}

