/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.OverridePrototypeAction;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class DeletePrototypeOverrideAction
extends AbstractDecompilerAction {
    public DeletePrototypeOverrideAction() {
        super("Remove Signature Override");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRemoveOverride"));
        this.setPopupMenuData(new MenuData(new String[]{"Remove Signature Override"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        return OverridePrototypeAction.getSymbol(function, context.getTokenAtCursor()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function func = context.getFunction();
        Symbol sym = OverridePrototypeAction.getSymbol(func, context.getTokenAtCursor());
        if (sym == null) {
            return;
        }
        Program program = func.getProgram();
        int txId = program.startTransaction("Remove Override Signature");
        try {
            DataTypeSymbol dts = HighFunctionDBUtil.readOverride((Symbol)sym);
            sym.delete();
            dts.cleanupUnusedOverride();
        }
        finally {
            program.endTransaction(txId, true);
        }
    }
}

