/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.ParameterIterator;
import org.jf.dexlib2.dexbacked.util.VariableSizeIterator;
import org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LocalInfo;
import org.jf.dexlib2.immutable.debug.ImmutableEndLocal;
import org.jf.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import org.jf.dexlib2.immutable.debug.ImmutablePrologueEnd;
import org.jf.dexlib2.immutable.debug.ImmutableRestartLocal;
import org.jf.dexlib2.immutable.debug.ImmutableSetSourceFile;
import org.jf.dexlib2.immutable.debug.ImmutableStartLocal;

public abstract class DebugInfo
implements Iterable<DebugItem> {
    @Nonnull
    public abstract Iterator<String> getParameterNames(@Nullable DexReader var1);

    public abstract int getSize();

    public static DebugInfo newOrEmpty(@Nonnull DexBackedDexFile dexFile, int debugInfoOffset, @Nonnull DexBackedMethodImplementation methodImpl) {
        if (debugInfoOffset == 0) {
            return EmptyDebugInfo.INSTANCE;
        }
        return new DebugInfoImpl(dexFile, debugInfoOffset, methodImpl);
    }

    private static class DebugInfoImpl
    extends DebugInfo {
        @Nonnull
        public final DexBackedDexFile dexFile;
        private final int debugInfoOffset;
        @Nonnull
        private final DexBackedMethodImplementation methodImpl;
        private static final LocalInfo EMPTY_LOCAL_INFO = new LocalInfo(){

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            @Nullable
            public String getType() {
                return null;
            }

            @Override
            @Nullable
            public String getSignature() {
                return null;
            }
        };

        public DebugInfoImpl(@Nonnull DexBackedDexFile dexFile, int debugInfoOffset, @Nonnull DexBackedMethodImplementation methodImpl) {
            this.dexFile = dexFile;
            this.debugInfoOffset = debugInfoOffset;
            this.methodImpl = methodImpl;
        }

        @Override
        @Nonnull
        public Iterator<DebugItem> iterator() {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.debugInfoOffset);
            final int lineNumberStart = reader.readBigUleb128();
            int registerCount = this.methodImpl.getRegisterCount();
            Object[] locals = new LocalInfo[registerCount];
            Arrays.fill(locals, EMPTY_LOCAL_INFO);
            DexBackedMethod method = this.methodImpl.method;
            ParameterIterator parameterIterator = new ParameterIterator(method.getParameterTypes(), method.getParameterAnnotations(), this.getParameterNames(reader));
            int parameterIndex = 0;
            if (!AccessFlags.STATIC.isSet(this.methodImpl.method.getAccessFlags())) {
                locals[parameterIndex++] = new LocalInfo(){

                    @Override
                    public String getName() {
                        return "this";
                    }

                    @Override
                    public String getType() {
                        return ((DebugInfoImpl)this).methodImpl.method.getDefiningClass();
                    }

                    @Override
                    public String getSignature() {
                        return null;
                    }
                };
            }
            while (parameterIterator.hasNext()) {
                locals[parameterIndex++] = (LocalInfo)parameterIterator.next();
            }
            if (parameterIndex < registerCount) {
                Object currentLocal;
                String type;
                int localIndex = registerCount - 1;
                while (--parameterIndex > -1 && ((type = (currentLocal = locals[parameterIndex]).getType()) == null || !type.equals("J") && !type.equals("D") || --localIndex != parameterIndex)) {
                    locals[localIndex] = currentLocal;
                    locals[parameterIndex] = EMPTY_LOCAL_INFO;
                    --localIndex;
                }
            }
            return new VariableSizeLookaheadIterator<DebugItem>(this.dexFile.getDataBuffer(), reader.getOffset(), (LocalInfo[])locals){
                private int codeAddress;
                private int lineNumber;
                final /* synthetic */ LocalInfo[] val$locals;
                {
                    this.val$locals = localInfoArray;
                    super(buffer, offset);
                    this.codeAddress = 0;
                    this.lineNumber = lineNumberStart;
                }

                @Override
                @Nullable
                protected DebugItem readNextItem(@Nonnull DexReader reader) {
                    int next;
                    block12: while (true) {
                        next = reader.readUbyte();
                        switch (next) {
                            case 0: {
                                return (DebugItem)this.endOfData();
                            }
                            case 1: {
                                int addressDiff = reader.readSmallUleb128();
                                this.codeAddress += addressDiff;
                                continue block12;
                            }
                            case 2: {
                                int lineDiff = reader.readSleb128();
                                this.lineNumber += lineDiff;
                                continue block12;
                            }
                            case 3: {
                                int register = reader.readSmallUleb128();
                                String name = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                String type = dexFile.getTypeSection().getOptional(reader.readSmallUleb128() - 1);
                                ImmutableStartLocal startLocal = new ImmutableStartLocal(this.codeAddress, register, name, type, null);
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = startLocal;
                                }
                                return startLocal;
                            }
                            case 4: {
                                int register = reader.readSmallUleb128();
                                String name = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                String type = dexFile.getTypeSection().getOptional(reader.readSmallUleb128() - 1);
                                String signature = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                ImmutableStartLocal startLocal = new ImmutableStartLocal(this.codeAddress, register, name, type, signature);
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = startLocal;
                                }
                                return startLocal;
                            }
                            case 5: {
                                LocalInfo localInfo;
                                int register = reader.readSmallUleb128();
                                boolean replaceLocalInTable = true;
                                if (register >= 0 && register < this.val$locals.length) {
                                    localInfo = this.val$locals[register];
                                } else {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    replaceLocalInTable = false;
                                }
                                if (localInfo instanceof EndLocal) {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    replaceLocalInTable = false;
                                }
                                ImmutableEndLocal endLocal = new ImmutableEndLocal(this.codeAddress, register, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (replaceLocalInTable) {
                                    this.val$locals[register] = endLocal;
                                }
                                return endLocal;
                            }
                            case 6: {
                                int register = reader.readSmallUleb128();
                                LocalInfo localInfo = register >= 0 && register < this.val$locals.length ? this.val$locals[register] : EMPTY_LOCAL_INFO;
                                ImmutableRestartLocal restartLocal = new ImmutableRestartLocal(this.codeAddress, register, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = restartLocal;
                                }
                                return restartLocal;
                            }
                            case 7: {
                                return new ImmutablePrologueEnd(this.codeAddress);
                            }
                            case 8: {
                                return new ImmutableEpilogueBegin(this.codeAddress);
                            }
                            case 9: {
                                String sourceFile = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                return new ImmutableSetSourceFile(this.codeAddress, sourceFile);
                            }
                        }
                        break;
                    }
                    int adjusted = next - 10;
                    this.codeAddress += adjusted / 15;
                    this.lineNumber += adjusted % 15 - 4;
                    return new ImmutableLineNumber(this.codeAddress, this.lineNumber);
                }
            };
        }

        @Nonnull
        public VariableSizeIterator<String> getParameterNames(@Nullable DexReader reader) {
            if (reader == null) {
                reader = this.dexFile.getDataBuffer().readerAt(this.debugInfoOffset);
                reader.skipUleb128();
            }
            int parameterNameCount = reader.readSmallUleb128();
            return new VariableSizeIterator<String>(reader, parameterNameCount){

                @Override
                protected String readNextItem(@Nonnull DexReader reader, int index) {
                    return dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                }
            };
        }

        @Override
        public int getSize() {
            Iterator<DebugItem> iter = this.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            return ((VariableSizeLookaheadIterator)iter).getReaderOffset() - this.debugInfoOffset;
        }
    }

    private static class EmptyDebugInfo
    extends DebugInfo {
        public static final EmptyDebugInfo INSTANCE = new EmptyDebugInfo();

        private EmptyDebugInfo() {
        }

        @Override
        @Nonnull
        public Iterator<DebugItem> iterator() {
            return ImmutableSet.of().iterator();
        }

        @Override
        @Nonnull
        public Iterator<String> getParameterNames(@Nullable DexReader reader) {
            return ImmutableSet.of().iterator();
        }

        @Override
        public int getSize() {
            return 0;
        }
    }
}

