/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.SkipStep;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.trace.model.time.schedule.TickStep;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public interface Step
extends Comparable<Step> {
    public static Step parse(String stepSpec, TraceSchedule.TimeRadix radix) {
        String tPart;
        if ("".equals(stepSpec)) {
            return Step.nop();
        }
        String[] parts = stepSpec.split("-");
        if (parts.length == 1) {
            return Step.parse(-1L, parts[0].trim(), radix);
        }
        if (parts.length == 2 && (tPart = parts[0].trim()).startsWith("t")) {
            return Step.parse(Long.parseLong(tPart.substring(1)), parts[1].trim(), radix);
        }
        throw new IllegalArgumentException("Cannot parse step: '" + stepSpec + "'");
    }

    public static Step parse(long threadKey, String stepSpec, TraceSchedule.TimeRadix radix) {
        if (stepSpec.startsWith("s")) {
            return SkipStep.parse(threadKey, stepSpec, radix);
        }
        if (stepSpec.startsWith("{")) {
            return PatchStep.parse(threadKey, stepSpec);
        }
        return TickStep.parse(threadKey, stepSpec, radix);
    }

    public static TickStep nop() {
        return new TickStep(-1L, 0L);
    }

    public String toString(TraceSchedule.TimeRadix var1);

    public StepType getType();

    default public int getTypeOrder() {
        return this.getType().ordinal();
    }

    public boolean isNop();

    public long getThreadKey();

    default public boolean isEventThread() {
        return this.getThreadKey() == -1L;
    }

    public static TraceThread requireThread(TraceThread thread, long key) {
        if (thread == null) {
            if (key == -1L) {
                throw new IllegalArgumentException("Thread must be given, e.g., 0:t1-3, since the last thread or snapshot event thread is not given.");
            }
            throw new IllegalArgumentException("Thread with key %d does not exist in given trace".formatted(key));
        }
        return thread;
    }

    default public TraceThread getThread(TraceThreadManager tm, TraceThread eventThread) {
        long key = this.getThreadKey();
        return Step.requireThread(this.isEventThread() ? eventThread : tm.getThread(key), key);
    }

    public long getTickCount();

    public long getSkipCount();

    public long getPatchCount();

    public boolean isCompatible(Step var1);

    public void addTo(Step var1);

    public Step subtract(Step var1);

    public Step clone();

    public long rewind(long var1);

    public CompareResult compareStep(Step var1);

    default public CompareResult compareStepType(Step that) {
        return CompareResult.unrelated(Integer.compare(this.getTypeOrder(), that.getTypeOrder()));
    }

    @Override
    default public int compareTo(Step that) {
        return this.compareStep((Step)that).compareTo;
    }

    default public TraceThread execute(TraceThreadManager tm, TraceThread eventThread, PcodeMachine<?> machine, Stepper stepper, TaskMonitor monitor) throws CancelledException {
        TraceThread thread = this.getThread(tm, eventThread);
        if (machine == null) {
            return thread;
        }
        PcodeThread emuThread = machine.getThread(thread.getPath(), true);
        this.execute(emuThread, stepper, monitor);
        return thread;
    }

    public void execute(PcodeThread<?> var1, Stepper var2, TaskMonitor var3) throws CancelledException;

    public long coalescePatches(Language var1, List<Step> var2);

    public static enum StepType {
        TICK,
        SKIP,
        PATCH;

    }
}

