/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class ResponseInsert
extends QueryResponseRecord {
    public int numexe;
    public int numfunc;

    public ResponseInsert() {
        super("responseinsert");
    }

    @Override
    public void mergeResults(QueryResponseRecord subresponse) {
        ResponseInsert subinsert = (ResponseInsert)subresponse;
        this.numexe += subinsert.numexe;
        this.numfunc += subinsert.numfunc;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        fwrite.append(" <numexe>").append(SpecXmlUtils.encodeSignedInteger((long)this.numexe)).append("</numexe>\n");
        fwrite.append(" <numfunc>").append(SpecXmlUtils.encodeSignedInteger((long)this.numfunc)).append("</numfunc>\n");
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        parser.start(new String[]{"numexe"});
        this.numexe = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.start(new String[]{"numfunc"});
        this.numfunc = SpecXmlUtils.decodeInt((String)parser.end().getText());
        parser.end();
    }
}

