/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import docking.widgets.textfield.HintTextField;
import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.gui.filters.BSimValueEditor;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import utility.function.Callback;

public class StringBSimValueEditor
implements BSimValueEditor {
    private BSimFilterType filterType;
    private Callback listener;
    private HintTextField textField;
    private boolean isValid;

    public StringBSimValueEditor(BSimFilterType filterType, List<String> initialValues, Callback listener) {
        this.filterType = filterType;
        this.listener = Callback.dummyIfNull((Callback)listener);
        this.textField = new HintTextField(filterType.getHint());
        this.textField.setColumns(20);
        this.setValues(initialValues);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                StringBSimValueEditor.this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StringBSimValueEditor.this.documentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StringBSimValueEditor.this.documentChanged();
            }
        });
        this.checkValid();
    }

    protected void documentChanged() {
        Swing.runLater(() -> {
            this.checkValid();
            this.listener.call();
        });
    }

    @Override
    public void setValues(List<String> values) {
        if (values == null) {
            this.textField.setText("");
        } else {
            String value = values.stream().collect(Collectors.joining(", "));
            this.textField.setText(value);
        }
    }

    @Override
    public List<String> getValues() {
        String text = this.textField.getText().trim();
        if (text.contains(",")) {
            String[] vals;
            ArrayList<String> values = new ArrayList<String>();
            for (String val : vals = text.split(",")) {
                if (val == null || val.isBlank()) continue;
                values.add(val.trim());
            }
            return values;
        }
        return List.of(text);
    }

    @Override
    public JComponent getComponent() {
        return this.textField;
    }

    @Override
    public boolean hasValidValues() {
        return this.isValid;
    }

    private void checkValid() {
        this.isValid = this.checkForValidValues();
        this.textField.setBackground(this.isValid ? VALID_COLOR : INVALID_COLOR);
    }

    private boolean checkForValidValues() {
        List<String> values = this.getValues();
        if (values == null || values.size() == 0) {
            return this.filterType.isValidValue("");
        }
        for (String string : values) {
            if (this.filterType.isValidValue(string)) continue;
            return false;
        }
        return true;
    }
}

