/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.ProgramProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.DifferenceAddressSetView;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class EmulatorUtilities
extends Enum<EmulatorUtilities> {
    public static final String BLOCK_NAME_STACK = "STACK";
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    public static final int DEFAULT_STACK_SIZE = 16384;
    public static final long PAGE_ZERO_END = 4096L;
    private static final /* synthetic */ EmulatorUtilities[] $VALUES;

    public static EmulatorUtilities[] values() {
        return (EmulatorUtilities[])$VALUES.clone();
    }

    public static EmulatorUtilities valueOf(String name) {
        return Enum.valueOf(EmulatorUtilities.class, name);
    }

    public static <T> void loadProgram(PcodeMachine<T> machine, Program program, int blockSize) throws MemoryAccessException {
        byte[] buf = new byte[blockSize];
        PcodeExecutorState<T> state = machine.getSharedState();
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (!block.isInitialized()) continue;
            for (AddressRange rng : new AddressRangeChunker(block.getAddressRange(), buf.length)) {
                int len = block.getBytes(rng.getMinAddress(), buf);
                state.setConcrete(rng.getMinAddress(), len == buf.length ? buf : Arrays.copyOf(buf, len));
            }
        }
    }

    public static void loadProgram(PcodeMachine<?> machine, Program program) throws MemoryAccessException {
        EmulatorUtilities.loadProgram(machine, program, 4096);
    }

    public static AddressRange chooseStackRangeFromContext(Program program, Address entry, int stackSize) {
        CompilerSpec cSpec;
        Register sp;
        ProgramContext ctx = program.getProgramContext();
        RegisterValue spVal = ctx.getRegisterValue(sp = (cSpec = program.getCompilerSpec()).getStackPointer(), entry);
        if (spVal == null || !spVal.hasValue()) {
            return null;
        }
        Address spAddr = cSpec.getStackBaseSpace().getAddress(spVal.getUnsignedValue().longValue());
        if (cSpec.stackGrowsNegative()) {
            Address max = spAddr.subtractWrap(1L);
            Address min = spAddr.subtractWrap((long)stackSize);
            if (min.compareTo((Object)max) > 0) {
                return new AddressRangeImpl(max.getAddressSpace().getMinAddress(), max);
            }
            return new AddressRangeImpl(min, max);
        }
        Address min = spAddr;
        Address max = spAddr.addWrap((long)(stackSize - 1));
        if (min.compareTo((Object)max) > 0) {
            return new AddressRangeImpl(min, min.getAddressSpace().getMaxAddress());
        }
        return new AddressRangeImpl(min, max);
    }

    public static AddressRange chooseStackRangeFromBlock(Program program) {
        AddressSpace space = program.getCompilerSpec().getStackBaseSpace();
        MemoryBlock stackBlock = program.getMemory().getBlock(BLOCK_NAME_STACK);
        if (stackBlock == null) {
            return null;
        }
        if (space != stackBlock.getStart().getAddressSpace().getPhysicalSpace()) {
            Msg.showError(EmulatorUtilities.class, null, (String)"Invalid STACK block", (Object)"The STACK block must be in the stack's base space. Ignoring.");
            return null;
        }
        return new AddressRangeImpl(stackBlock.getStart().getPhysicalAddress(), stackBlock.getEnd().getPhysicalAddress());
    }

    public static AddressRange chooseStackRange(Program program, Address entry, int stackSize) {
        AddressRange customByContext = EmulatorUtilities.chooseStackRangeFromContext(program, entry, stackSize);
        if (customByContext != null) {
            return customByContext;
        }
        AddressRange customByBlock = EmulatorUtilities.chooseStackRangeFromBlock(program);
        if (customByBlock != null) {
            return customByBlock;
        }
        AddressSpace space = program.getCompilerSpec().getStackBaseSpace();
        Address max = space.getMaxAddress();
        AddressSet eligible = max.getOffsetAsBigInteger().compareTo(BigInteger.valueOf(4096L)) < 0 ? new AddressSet(space.getMinAddress(), max) : new AddressSet(space.getAddress(4096L), max);
        DifferenceAddressSetView left = new DifferenceAddressSetView((AddressSetView)eligible, (AddressSetView)program.getMemory());
        for (AddressRange candidate : left) {
            if (Long.compareUnsigned(candidate.getLength(), stackSize) < 0) continue;
            try {
                return new AddressRangeImpl(candidate.getMinAddress(), (long)stackSize);
            }
            catch (AddressOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new NoSuchElementException();
    }

    public static AddressRange chooseStackRange(Program program, Address entry) {
        return EmulatorUtilities.chooseStackRange(program, entry, 16384);
    }

    public static <T> void initializeForFunction(PcodeThread<T> thread, Function function, int stackSize) {
        PcodeArithmetic<T> arithmetic = thread.getArithmetic();
        Program program = function.getProgram();
        Address entry = function.getEntryPoint();
        CompilerSpec cSpec = program.getCompilerSpec();
        Register sp = cSpec.getStackPointer();
        ThreadPcodeExecutorState<T> state = thread.getState();
        ProgramProcessorContext ctx = new ProgramProcessorContext(program.getProgramContext(), entry);
        for (Register reg : ctx.getRegisters()) {
            RegisterValue rv;
            if (!reg.isBaseRegister() || (rv = ctx.getRegisterValue(reg)) == null || !rv.hasAnyValue()) continue;
            state.setRegisterValue(rv);
        }
        AddressRange stack = EmulatorUtilities.chooseStackRange(program, entry);
        long stackOffset = cSpec.stackGrowsNegative() ? stack.getMaxAddress().getOffset() + 1L : stack.getMinAddress().getOffset();
        state.setVar(sp, arithmetic.fromConst(stackOffset, sp.getMinimumByteSize()));
        thread.overrideCounter(entry);
    }

    private static /* synthetic */ EmulatorUtilities[] $values() {
        return new EmulatorUtilities[0];
    }

    static {
        $VALUES = EmulatorUtilities.$values();
    }
}

