/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.net.URI;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);

    protected abstract String extractRootPrefix(String var1, StringBuilder var2) throws FileSystemException;

    private String[] getSchemes(VfsComponentContext context, FileName base, String uri) {
        if (context == null) {
            return new String[]{base != null ? base.getScheme() : URI.create(uri).getScheme()};
        }
        return context.getFileSystemManager().getSchemes();
    }

    public boolean isAbsoluteName(String name) {
        StringBuilder b = new StringBuilder(name);
        try {
            UriParser.fixSeparators(b);
            this.extractRootPrefix(name, b);
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder nameBuilder = new StringBuilder();
        String scheme = UriParser.extractScheme(this.getSchemes(context, base, uri), uri, nameBuilder);
        if (scheme == null && base != null) {
            scheme = base.getScheme();
        }
        if (scheme == null) {
            scheme = "file";
        }
        UriParser.canonicalizePath(nameBuilder, 0, nameBuilder.length(), this);
        UriParser.fixSeparators(nameBuilder);
        String rootFile = this.extractRootPrefix(uri, nameBuilder);
        FileType fileType = UriParser.normalisePath(nameBuilder);
        String path = nameBuilder.toString();
        return this.createFileName(scheme, rootFile, path, fileType);
    }
}

