/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.unix;

import ghidra.pcode.emu.unix.EmuUnixUser;

public class EmuUnixFileStat {
    public static final int MODE_R = 4;
    public static final int MODE_W = 2;
    public static final int MODE_X = 1;
    public long st_dev;
    public long st_ino;
    public int st_mode;
    public long st_nlink;
    public int st_uid;
    public int st_gid;
    public long st_rdev;
    public long st_size;
    public long st_blksize;
    public long st_blocks;
    public long st_atim_sec;
    public long st_atim_nsec;
    public long st_mtim_sec;
    public long st_mtim_nsec;
    public long st_ctim_sec;
    public long st_ctim_nsec;

    public boolean hasPermissions(int req, EmuUnixUser user) {
        if ((this.st_mode & req) == req) {
            return true;
        }
        if ((this.st_mode >> 6 & req) == req && user.uid == this.st_uid) {
            return true;
        }
        return (this.st_mode >> 3 & req) == req && user.gids.contains(this.st_gid);
    }
}

