/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state.analysis;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.state.analysis.Switch;
import ghidra.util.state.analysis.TableEntry;

public class RelativeJumpTableSwitch
extends Switch {
    private final Address jumpBase;
    private final TableEntry offset;

    public RelativeJumpTableSwitch(Address jumpBase, TableEntry offset) {
        this.jumpBase = jumpBase;
        this.offset = offset;
    }

    @Override
    Address getCaseAddress(int caseIndexValue) throws MemoryAccessException, AddressOutOfBoundsException {
        long displacement = this.offset.getTableEntryValue(caseIndexValue, 1, false);
        return this.jumpBase.add(displacement);
    }

    @Override
    Varnode getIndexValue() {
        return this.offset.getIndexValue();
    }

    static RelativeJumpTableSwitch getRelativeJumpTableSwitch(Program program, VarnodeOperation op) {
        if (op.getPCodeOp().getOpcode() != 19) {
            return null;
        }
        AddressFactory addrFactory = program.getAddressFactory();
        Address jumpBase = null;
        TableEntry offset = null;
        Address opAddr = op.getPCodeOp().getSeqnum().getTarget();
        Varnode[] inputValues = op.getInputValues();
        if (inputValues[0].isConstant()) {
            jumpBase = RelativeJumpTableSwitch.getAddress(addrFactory, inputValues[0].getOffset(), opAddr);
            offset = TableEntry.getTableEntry(program, inputValues[1]);
        } else if (inputValues[1].isConstant()) {
            jumpBase = RelativeJumpTableSwitch.getAddress(addrFactory, inputValues[1].getOffset(), opAddr);
            offset = TableEntry.getTableEntry(program, inputValues[0]);
        }
        if (jumpBase == null || offset == null) {
            return null;
        }
        return new RelativeJumpTableSwitch(jumpBase, offset);
    }

    private static Address getAddress(AddressFactory addrFactory, long offset, Address closeToAddr) {
        try {
            Address addr = addrFactory.getDefaultAddressSpace().getAddress(offset);
            long distance = addr.subtract(closeToAddr);
            if (distance > -128L && distance < 128L) {
                return addr;
            }
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }
}

