/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.Msg;
import java.io.Closeable;

public class FileSystemRef
implements Closeable {
    private final GFileSystem fs;
    private boolean refClosed = false;

    FileSystemRef(GFileSystem fs) {
        this.fs = fs;
    }

    public FileSystemRef dup() {
        return this.fs.getRefManager().create();
    }

    public GFileSystem getFilesystem() {
        return this.fs;
    }

    @Override
    public void close() {
        this.fs.getRefManager().release(this);
        this.refClosed = true;
    }

    public boolean isClosed() {
        return this.refClosed;
    }

    public void finalize() {
        if (!this.refClosed) {
            Msg.warn((Object)this, (Object)("Unclosed FilesytemRef: " + this.fs.toString()));
        }
    }

    public String toString() {
        return this.fs.getFSRL().toString();
    }
}

