/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.items.CompositeFieldQuickFix;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

public class RenameFieldQuickFix
extends CompositeFieldQuickFix {
    public RenameFieldQuickFix(Program program, Composite composite, int ordinal, String original, String newName) {
        super(program, composite, ordinal, original, newName);
    }

    @Override
    public String getActionName() {
        return "Rename";
    }

    @Override
    public String getItemType() {
        return "Field Name";
    }

    @Override
    public String doGetCurrent() {
        DataTypeComponent component = this.getComponent();
        return component == null ? null : component.getFieldName();
    }

    private DataTypeComponent getComponent() {
        DataTypeComponent component = this.findComponent(this.original);
        if (component == null) {
            component = this.findComponent(this.replacement);
        }
        return component;
    }

    @Override
    public void execute() {
        try {
            DataTypeComponent component = this.getComponent();
            if (component != null) {
                component.setFieldName(this.replacement);
            }
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename field failed: " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    protected String getFieldName() {
        return this.current;
    }
}

