/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import generic.theme.GColor;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.program.database.IntRangeMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramEvent;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class PropertyBasedBackgroundColorModel
implements ListingBackgroundColorModel,
DomainObjectListener {
    public static final String COLOR_PROPERTY_NAME = "LISTING_COLOR";
    private IntRangeMap colorMap;
    private AddressIndexMap indexMap;
    private Color defaultBackgroundColor = new GColor("color.bg.listing");
    private Map<Integer, Color> colorCache = new HashMap<Integer, Color>();
    private Program program;
    private boolean enabled = false;

    @Override
    public void modelDataChanged(ListingPanel listingPanel) {
        Program newProgram = listingPanel.getProgram();
        this.updateListener(newProgram);
        this.program = newProgram;
        this.indexMap = listingPanel.getAddressIndexMap();
        this.colorMap = this.program == null ? null : this.program.getIntRangeMap(COLOR_PROPERTY_NAME);
    }

    private void updateListener(Program newProgram) {
        if (newProgram == this.program) {
            return;
        }
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        if (newProgram != null) {
            newProgram.addListener((DomainObjectListener)this);
        }
    }

    public Color getBackgroundColor(BigInteger index) {
        if (!this.enabled || this.colorMap == null) {
            return this.defaultBackgroundColor;
        }
        Address address = this.indexMap.getAddress(index);
        Color color = null;
        if (address != null) {
            color = this.getColor(address);
        }
        if (color == null) {
            color = this.defaultBackgroundColor;
        }
        return color;
    }

    private Color getColor(Address address) {
        Integer value = this.colorMap.getValue(address);
        if (value == null) {
            return null;
        }
        Color c = this.colorCache.get(value);
        if (c == null) {
            c = ColorUtils.getColor((int)value);
            this.colorCache.put(value, c);
        }
        return c;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains(new EventType[]{ProgramEvent.INT_PROPERTY_MAP_ADDED, ProgramEvent.INT_PROPERTY_MAP_REMOVED})) {
            this.colorMap = this.program.getIntRangeMap(COLOR_PROPERTY_NAME);
        }
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }
}

