/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AbstractOffsetFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.util.OffsetFieldType;

public class FileOffsetFieldFactory
extends AbstractOffsetFieldFactory {
    private static final String FIELD_OFFSET_DESCRIPTION = "File";
    private static final String FIELD_NAME_DESCRIPTION = "File";

    public FileOffsetFieldFactory() {
        super("File");
    }

    private FileOffsetFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super("File", "File", model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider highlightProvider, ToolOptions options, ToolOptions fieldOptions) {
        return new FileOffsetFieldFactory(formatModel, highlightProvider, (Options)options, (Options)fieldOptions);
    }

    @Override
    public String getOffsetValue(CodeUnit cu) {
        Address addr = cu.getAddress();
        MemoryBlock block = cu.getProgram().getMemory().getBlock(addr);
        String text = "";
        for (MemoryBlockSourceInfo sourceInfo : block.getSourceInfos()) {
            if (!sourceInfo.contains(addr) || !sourceInfo.getFileBytes().isPresent()) continue;
            FileBytes fileBytes = (FileBytes)sourceInfo.getFileBytes().get();
            long offset = sourceInfo.getFileBytesOffset(addr);
            text = String.format(this.useHex ? "0x%x" : "%d", offset);
            if (!this.showName) break;
            text = "%s:%s".formatted(fileBytes.getFilename(), text);
            break;
        }
        return text;
    }

    @Override
    public OffsetFieldType getOffsetFieldType() {
        return OffsetFieldType.FILE;
    }
}

