/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

public class OMFSrcModuleLine {
    private short seg;
    private short cPair;
    private int[] offsets;
    private short[] linenumbers;

    OMFSrcModuleLine(BinaryReader reader, int ptr) throws IOException {
        int i;
        int index = ptr;
        this.seg = reader.readShort(index);
        this.cPair = reader.readShort(index += 2);
        index += 2;
        this.offsets = new int[Short.toUnsignedInt(this.cPair)];
        for (i = 0; i < Short.toUnsignedInt(this.cPair); ++i) {
            this.offsets[i] = reader.readInt(index);
            index += 4;
        }
        this.linenumbers = new short[Short.toUnsignedInt(this.cPair)];
        for (i = 0; i < Short.toUnsignedInt(this.cPair); ++i) {
            this.linenumbers[i] = reader.readShort(index);
            index += 2;
        }
    }

    public short getPairCount() {
        return this.cPair;
    }

    public short[] getLinenumbers() {
        return this.linenumbers;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public short getSegmentIndex() {
        return this.seg;
    }

    int getByteCount() {
        return 4 + 4 * this.cPair + 2 * this.cPair;
    }
}

