/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

public enum PeSubsystem {
    IMAGE_SUBSYSTEM_UNKNOWN("IMAGE_SUBSYSTEM_UNKNOWN", 0, "An unknown subsystem"),
    IMAGE_SUBSYSTEM_NATIVE("IMAGE_SUBSYSTEM_NATIVE", 1, "Device drivers and native Windows processes"),
    IMAGE_SUBSYSTEM_WINDOWS_GUI("IMAGE_SUBSYSTEM_WINDOWS_GUI", 2, "The Windows graphical user interface (GUI) subsystem"),
    IMAGE_SUBSYSTEM_WINDOWS_CUI("IMAGE_SUBSYSTEM_WINDOWS_CUI", 3, "The Windows character subsystem"),
    IMAGE_SUBSYSTEM_OS2_CUI("IMAGE_SUBSYSTEM_OS2_CUI", 5, "The OS/2 character subsystem"),
    IMAGE_SUBSYSTEM_POSIX_CUI("IMAGE_SUBSYSTEM_POSIX_CUI", 7, "The Posix character subsystem"),
    IMAGE_SUBSYSTEM_NATIVE_WINDOWS("IMAGE_SUBSYSTEM_NATIVE_WINDOWS", 8, "Native Win9x driver"),
    IMAGE_SUBSYSTEM_WINDOWS_CE_GUI("IMAGE_SUBSYSTEM_WINDOWS_CE_GUI", 9, "Windows CE"),
    IMAGE_SUBSYSTEM_EFI_APPLICATION("IMAGE_SUBSYSTEM_EFI_APPLICATION", 10, "An Extensible Firmware Interface (EFI) application"),
    IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER("IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER", 11, "An Extensible Firmware Interface (EFI) driver with boot services"),
    IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER("IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER", 12, "An Extensible Firmware Interface (EFI) driver with run-time services"),
    IMAGE_SUBSYSTEM_EFI_ROM("IMAGE_SUBSYSTEM_EFI_ROM", 13, "An Extensible Firmware Interface (EFI) ROM image"),
    IMAGE_SUBSYSTEM_XBOX("IMAGE_SUBSYSTEM_XBOX", 14, "XBOX Image"),
    IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION("IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION", 16, "Windows boot application.");

    private final String alias;
    private final int value;
    private final String description;

    private PeSubsystem(String alias, int value, String description) {
        this.alias = alias;
        this.value = value;
        this.description = description;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public static PeSubsystem parse(int id) {
        for (PeSubsystem ss : PeSubsystem.values()) {
            if (ss.getValue() != id) continue;
            return ss;
        }
        throw new IllegalArgumentException("Can't resolve '" + id + "' to known PeSubsystem");
    }
}

