/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.format.pe.BaseRelocation;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

public class BaseRelocationDataDirectory
extends DataDirectory
implements ByteArrayConverter {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_BASERELOC";
    private BaseRelocation[] relocs;

    BaseRelocationDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
        if (this.relocs == null) {
            this.relocs = new BaseRelocation[0];
        }
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws CodeUnitInsertionException {
        monitor.setMessage(program.getName() + ": base relocation(s)...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, nt, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        for (BaseRelocation reloc : this.relocs) {
            if (monitor.isCancelled()) {
                return;
            }
            PeUtils.createData(program, addr, (DataType)DWordDataType.dataType, log);
            addr = addr.add((long)DWordDataType.dataType.getLength());
            PeUtils.createData(program, addr, (DataType)DWordDataType.dataType, log);
            addr = addr.add((long)DWordDataType.dataType.getLength());
            int count = reloc.getCount();
            for (int j = 0; j < count; ++j) {
                if (monitor.isCancelled()) {
                    return;
                }
                PeUtils.createData(program, addr, (DataType)WordDataType.dataType, log);
                addr = addr.add((long)WordDataType.dataType.getLength());
            }
        }
    }

    @Override
    public boolean parse() throws IOException {
        BaseRelocation br;
        int addr = this.getPointer();
        if (addr < 0) {
            return false;
        }
        int stop = addr + this.getSize();
        ArrayList<BaseRelocation> relocsList = new ArrayList<BaseRelocation>();
        while (addr < stop && (br = new BaseRelocation(this.reader, addr)).getVirtualAddress() != 0 && br.getSizeOfBlock() >= 8 && br.getSizeOfBlock() != 0) {
            relocsList.add(br);
            addr += br.getSizeOfBlock();
        }
        this.relocs = new BaseRelocation[relocsList.size()];
        relocsList.toArray(this.relocs);
        return true;
    }

    public BaseRelocation[] getBaseRelocations() {
        return this.relocs;
    }

    public void removeAllRelocations() {
        this.relocs = new BaseRelocation[0];
        this.size = 0;
    }

    public BaseRelocation createBaseRelocation(int va) {
        return new BaseRelocation(va);
    }

    public void addBaseRelocation(BaseRelocation reloc) {
        this.size += reloc.getSizeOfBlock();
        BaseRelocation[] tmp = new BaseRelocation[this.relocs.length + 1];
        System.arraycopy(this.relocs, 0, tmp, 0, this.relocs.length);
        tmp[tmp.length - 1] = reloc;
        this.relocs = tmp;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        int lsize = 0;
        for (BaseRelocation reloc : this.relocs) {
            lsize += reloc.getSizeOfBlock();
        }
        byte[] bytes = new byte[lsize];
        int pos = 0;
        for (BaseRelocation reloc : this.relocs) {
            byte[] relocBytes = reloc.toBytes(dc);
            System.arraycopy(relocBytes, 0, bytes, pos, relocBytes.length);
            pos += relocBytes.length;
        }
        return bytes;
    }
}

