/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoIMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.FieldMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName={"runtime.interfacetype", "internal/abi.InterfaceType"})
public class GoInterfaceType
extends GoType {
    @FieldMapping
    @MarkupReference(value="getPkgPath")
    private long pkgpath;
    @FieldMapping(fieldName={"mhdr", "Methods"})
    private GoSlice mhdr;

    @Markup
    public GoName getPkgPath() throws IOException {
        return this.programContext.getGoName(this.pkgpath);
    }

    public GoSlice getMethodsSlice() {
        return this.mhdr;
    }

    public List<GoIMethod> getMethods() throws IOException {
        return this.mhdr.readList(GoIMethod.class);
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException, CancelledException {
        super.additionalMarkup(session);
        this.mhdr.markupArray(this.getStructureLabel() + "_methods", this.getStructureNamespace(), GoIMethod.class, false, session);
        this.mhdr.markupArrayElements(GoIMethod.class, session);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        GoTypeManager goTypes = this.programContext.getGoTypes();
        Structure genericIfaceDT = this.programContext.getStructureDataType(GoIface.class);
        CategoryPath ifaceCP = goTypes.getCP(this);
        String ifaceName = goTypes.getTypeName(this);
        StructureDataType ifaceDT = new StructureDataType(ifaceCP, ifaceName, genericIfaceDT.getLength(), goTypes.getDTM());
        ifaceDT.replaceWith((DataType)genericIfaceDT);
        goTypes.cacheRecoveredDataType(this, (DataType)ifaceDT);
        Structure itabStruct = this.getSpecializedITabStruct(ifaceCP, ifaceName, goTypes);
        int itabComponentOrdinal = 0;
        DataTypeComponentImpl genericItabDTC = ifaceDT.getComponent(itabComponentOrdinal);
        ifaceDT.replace(itabComponentOrdinal, (DataType)goTypes.getDTM().getPointer((DataType)itabStruct), -1, genericItabDTC.getFieldName(), null);
        return ifaceDT;
    }

    public Structure getSpecializedITabStruct(CategoryPath ifaceCP, String ifaceName, GoTypeManager goTypes) throws IOException {
        DataTypeManager dtm = goTypes.getDTM();
        Structure genericItabStruct = goTypes.getGenericITabDT();
        StructureDataType itabStruct = new StructureDataType(ifaceCP, ifaceName + "_itab", 0, dtm);
        itabStruct.replaceWith((DataType)genericItabStruct);
        FieldMappingInfo<Class<GoItab>> funFMI = this.programContext.getStructureMappingInfo(GoItab.class).getFieldInfo("fun");
        int funDTCOrdinal = funFMI.getDtc().getOrdinal();
        itabStruct.delete(funDTCOrdinal);
        CategoryPath funcsCP = ifaceCP.extend(new String[]{itabStruct.getName() + "_funcs"});
        for (GoIMethod imethod : this.getMethods()) {
            FunctionDefinition methodFuncDef = imethod.getFunctionDefinition(false, goTypes);
            try {
                methodFuncDef.setNameAndCategory(funcsCP, imethod.getName());
                itabStruct.add((DataType)dtm.getPointer((DataType)methodFuncDef), imethod.getName(), null);
                methodFuncDef.setCallingConvention(this.programContext.getDefaultCallingConventionName());
            }
            catch (InvalidNameException | DuplicateNameException | InvalidInputException e) {
                throw new IOException("Error creating itab for " + ifaceName, e);
            }
        }
        return itabStruct;
    }

    @Override
    public String getMethodListString() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (GoIMethod imethod : this.getMethods()) {
            String string;
            GoFuncType goFuncType;
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            if ((goFuncType = imethod.getType()) instanceof GoFuncType) {
                GoFuncType funcdefType = goFuncType;
                string = funcdefType.getParamListString();
            } else {
                string = "(???)";
            }
            String paramListStr = string;
            sb.append(imethod.getName()).append(paramListStr);
        }
        return sb.toString();
    }

    protected String getTypesThatImplementInterfaceString() {
        StringBuilder sb = new StringBuilder();
        for (GoItab goItab : this.programContext.getGoTypes().getTypesThatImplementInterface(this)) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            try {
                GoType type = goItab.getType();
                sb.append(AddressAnnotatedStringHandler.createAddressAnnotationString(type.getStructureContext().getStructureAddress(), type.getFullyQualifiedName()));
                sb.append(AddressAnnotatedStringHandler.createAddressAnnotationString(goItab.getStructureContext().getStructureAddress(), "[itab]"));
            }
            catch (IOException e) {
                sb.append("bad type info");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoIMethod imethod : this.getMethods()) {
            GoFuncType type = imethod.getType();
            if (type == null) continue;
            ((GoType)type).discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.typ.getSize() == (long)(this.programContext.getPtrSize() * 2);
    }

    @Override
    public String toString() {
        Object s = super.toString();
        String implementations = this.getTypesThatImplementInterfaceString();
        if (!implementations.isEmpty()) {
            s = (String)s + "\n\n// Implemented by:\n" + implementations;
        }
        return s;
    }
}

