/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.sourcefilestable;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.options.editor.StringWithChoicesEditor;
import docking.widgets.values.GValuesMap;
import docking.widgets.values.ValuesMapDialog;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.sourcefilestable.SourceFilesTableProvider;
import ghidra.app.services.EclipseIntegrationService;
import ghidra.app.services.VSCodeIntegrationService;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.UserDataPathTransformer;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.program.model.sourcemap.SourceMapEntry;
import ghidra.program.model.sourcemap.SourcePathTransformer;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SourceMapFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Source File Table", description="Plugin for viewing and managing source file information.", eventsConsumed={ProgramClosedPluginEvent.class})
public class SourceFilesTablePlugin
extends ProgramPlugin
implements OptionsChangeListener {
    private SourceFilesTableProvider provider;
    private DomainObjectListener listener;
    private static final String USE_EXISTING_AS_DEFAULT_OPTION_NAME = "Use Existing Path as Default";
    private boolean useExistingAsDefault = true;
    private static final String ECLIPSE = "Eclipse";
    private static final String VS_CODE = "VS Code";
    private static final String[] VIEWERS = new String[]{"Eclipse", "VS Code"};
    private static final String SELECTED_VIEWER_OPTION_NAME = "Viewer for Source Files";
    private String selectedViewer = "VS Code";
    private File vscodeExecutable = null;
    private File eclipseExecutable = null;

    public SourceFilesTablePlugin(PluginTool plugintool) {
        super(plugintool);
    }

    public void init() {
        super.init();
        this.provider = new SourceFilesTableProvider(this);
        this.listener = this.createDomainObjectListener();
        this.initOptions(this.tool.getOptions("Source Files and Transforms"));
        this.createAction();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        switch (optionName) {
            case "Use Existing Path as Default": {
                this.useExistingAsDefault = options.getBoolean(USE_EXISTING_AS_DEFAULT_OPTION_NAME, true);
                break;
            }
            case "Viewer for Source Files": {
                this.selectedViewer = options.getString(SELECTED_VIEWER_OPTION_NAME, VS_CODE);
                break;
            }
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener(this.listener);
        this.provider.programActivated(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener(this.listener);
        this.provider.clearTableModels();
    }

    protected void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener(this.listener);
        }
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).ignoreWhen(() -> !this.provider.isVisible())).any(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.MEMORY_BLOCK_MOVED, ProgramEvent.MEMORY_BLOCK_REMOVED}).terminate(c -> this.provider.setIsStale(true))).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.SOURCE_FILE_ADDED, ProgramEvent.SOURCE_FILE_REMOVED, ProgramEvent.SOURCE_MAP_CHANGED}).call(this.provider::handleProgramChange).build();
    }

    private void createAction() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("View Source", this.getName()).popupMenuPath(new String[]{"View Source..."})).popupMenuGroup("ZZZ")).helpLocation(new HelpLocation(this.getName(), "View_Source"))).withContext(ListingActionContext.class).enabledWhen(c -> this.isEnabled((ListingActionContext)c)).onAction(c -> this.viewSourceFile((ListingActionContext)c)).buildAndInstall((Tool)this.tool);
    }

    private boolean isEnabled(ListingActionContext context) {
        Address address = context.getAddress();
        SourceFileManager manager = this.getCurrentProgram().getSourceFileManager();
        return manager.getSourceMapEntries(address).size() > 0;
    }

    private void viewSourceFile(ListingActionContext context) {
        Address address = context.getAddress();
        SourceFileManager manager = this.getCurrentProgram().getSourceFileManager();
        List entries = manager.getSourceMapEntries(address);
        if (entries.isEmpty()) {
            return;
        }
        if (entries.size() == 1) {
            SourceMapEntry entry = (SourceMapEntry)entries.get(0);
            this.openInViewer(entry.getSourceFile(), entry.getLineNumber());
            return;
        }
        ProgramLocation programLocation = context.getLocation();
        if (programLocation instanceof SourceMapFieldLocation) {
            SourceMapFieldLocation sourceLoc = (SourceMapFieldLocation)programLocation;
            SourceMapEntry entry = sourceLoc.getSourceMapEntry();
            this.openInViewer(entry.getSourceFile(), entry.getLineNumber());
            return;
        }
        GValuesMap valuesMap = new GValuesMap();
        HashMap<String, SourceMapEntry> stringsToEntries = new HashMap<String, SourceMapEntry>();
        for (SourceMapEntry entry : entries) {
            stringsToEntries.put(entry.toString(), entry);
        }
        valuesMap.defineChoice("Entry", ((SourceMapEntry)entries.get(0)).toString(), stringsToEntries.keySet().toArray(new String[0]));
        ValuesMapDialog dialog = new ValuesMapDialog("Select Entry to View", null, valuesMap);
        DockingWindowManager.showDialog((DialogComponentProvider)dialog);
        if (dialog.isCancelled()) {
            return;
        }
        GValuesMap results = dialog.getValues();
        if (results == null) {
            return;
        }
        String selected = results.getChoice("Entry");
        if (selected == null) {
            return;
        }
        SourceMapEntry entryToShow = (SourceMapEntry)stringsToEntries.get(selected);
        this.openInViewer(entryToShow.getSourceFile(), entryToShow.getLineNumber());
    }

    void openInViewer(SourceFile sourceFile, int lineNum) {
        if (sourceFile == null) {
            return;
        }
        SourcePathTransformer transformer = UserDataPathTransformer.getPathTransformer((Program)this.currentProgram);
        String transformedPath = transformer.getTransformedPath(sourceFile, this.useExistingAsDefault);
        if (transformedPath == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"No Path Transform", (Object)("No path transformation applies to " + sourceFile.toString()));
            return;
        }
        File localSourceFile = new File(transformedPath);
        if (!localSourceFile.exists()) {
            Msg.showWarn((Object)transformer, null, (String)"File Not Found", (Object)(localSourceFile.getAbsolutePath() + " does not exist"));
            return;
        }
        switch (this.selectedViewer) {
            case "Eclipse": {
                this.openFileInEclipse(localSourceFile.getAbsolutePath(), lineNum);
                break;
            }
            case "VS Code": {
                this.openFileInVsCode(localSourceFile.getAbsolutePath(), lineNum);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Viewer: " + this.selectedViewer));
            }
        }
    }

    private void openFileInEclipse(String path, int lineNumber) {
        EclipseIntegrationService eclipseService = (EclipseIntegrationService)this.tool.getService(EclipseIntegrationService.class);
        if (eclipseService == null) {
            Msg.showError((Object)((Object)this), null, (String)"Eclipse Service Error", (Object)"Eclipse service not configured for tool");
            return;
        }
        try {
            this.eclipseExecutable = eclipseService.getEclipseExecutableFile();
        }
        catch (FileNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Eclipse Executable", (Object)e.getMessage());
            return;
        }
        MonitoredRunnable r = m -> {
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add(this.eclipseExecutable.getAbsolutePath());
                args.add(path + ":" + lineNumber);
                new ProcessBuilder(args).redirectErrorStream(true).start();
            }
            catch (Exception e) {
                eclipseService.handleEclipseError("Unexpected exception occurred while launching Eclipse.", false, null);
                return;
            }
        };
        new TaskBuilder("Opening File in Eclipse", r).setHasProgress(false).setCanCancel(true).launchModal();
    }

    private void openFileInVsCode(String path, int lineNumber) {
        VSCodeIntegrationService vscodeService = (VSCodeIntegrationService)this.tool.getService(VSCodeIntegrationService.class);
        if (vscodeService == null) {
            Msg.showError((Object)((Object)this), null, (String)"VSCode Service Error", (Object)"VSCode service not configured for tool");
            return;
        }
        try {
            this.vscodeExecutable = vscodeService.getVSCodeExecutableFile();
        }
        catch (FileNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Missing VSCode executable", (Object)e.getMessage());
            return;
        }
        MonitoredRunnable r = m -> {
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add(this.vscodeExecutable.getAbsolutePath());
                args.add("--goto");
                args.add(path + ":" + lineNumber);
                new ProcessBuilder(args).redirectErrorStream(true).start();
            }
            catch (Exception e) {
                vscodeService.handleVSCodeError("Unexpected exception occurred while launching Visual Studio Code.", false, null);
                return;
            }
        };
        new TaskBuilder("Opening File in VSCode", r).setHasProgress(false).setCanCancel(true).launchModal();
    }

    private void initOptions(ToolOptions options) {
        options.registerOption(USE_EXISTING_AS_DEFAULT_OPTION_NAME, (Object)true, new HelpLocation(this.getName(), "Use_Existing_As_Default"), "Use a source file's existing path if no transform applies");
        this.useExistingAsDefault = options.getBoolean(USE_EXISTING_AS_DEFAULT_OPTION_NAME, true);
        options.registerOption(SELECTED_VIEWER_OPTION_NAME, OptionType.STRING_TYPE, (Object)VS_CODE, new HelpLocation(this.getName(), "Viewer_for_Source_Files"), SELECTED_VIEWER_OPTION_NAME, () -> new StringWithChoicesEditor(VIEWERS));
        this.selectedViewer = options.getString(SELECTED_VIEWER_OPTION_NAME, VS_CODE);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        options.setOptionsHelpLocation(new HelpLocation(this.getName(), "Source_Files_Table_Plugin_Options"));
    }
}

