/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;

public class ConvertToUnsignedDecimalAction
extends AbstractConvertAction {
    public ConvertToUnsignedDecimalAction(EquatePlugin plugin) {
        super(plugin, "Convert To Unsigned Decimal", false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        Scalar s = scalar;
        if (s.isSigned()) {
            s = new Scalar(s.bitLength(), s.getUnsignedValue(), false);
        }
        return this.getStandardLengthString("Unsigned Decimal:") + s.toString(10, false, false, "", "");
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        return "" + scalar.getUnsignedValue();
    }

    @Override
    protected int getFormatChoice() {
        return 1;
    }
}

