/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import java.math.BigInteger;

class RegisterContextBuilder {
    private Program program;
    private Register reg;
    private boolean isBitRegister;
    private BigInteger mask;
    private Address setAddr;
    private BigInteger value;

    RegisterContextBuilder(Program program, Register reg, boolean isBitRegister) {
        this(program, reg, isBitRegister ? 1L : 0L);
        this.isBitRegister = isBitRegister;
    }

    RegisterContextBuilder(Program program, Register reg, long mask) {
        if (reg.isProcessorContext()) {
            throw new IllegalArgumentException("reg may not be processor context register");
        }
        this.program = program;
        this.reg = reg;
        this.isBitRegister = false;
        this.mask = mask != 0L ? BigInteger.valueOf(mask) : null;
    }

    void setValueUnknown() {
        this.value = null;
        this.setAddr = null;
    }

    void setValueAt(Instruction instr, BigInteger newValue, boolean valueAssumed) {
        if (instr == null || newValue == null) {
            throw new IllegalArgumentException("instr and newValue required");
        }
        Address address = this.setAddr = valueAssumed ? instr.getMinAddress() : instr.getFallThrough();
        if (this.setAddr != null) {
            this.value = newValue;
            if (this.mask != null) {
                this.value = this.value.and(this.mask);
            }
        }
    }

    void setValueAt(Instruction instr, long newValue, boolean assumed) {
        this.setValueAt(instr, BigInteger.valueOf(newValue), assumed);
    }

    boolean setValueAt(Instruction instr, Address valueFrom, boolean overwrite) {
        if (this.value == null || overwrite) {
            BigInteger val = this.program.getProgramContext().getValue(this.reg, valueFrom, false);
            if (val != null) {
                this.setValueAt(instr, val, true);
                return true;
            }
            this.setValueUnknown();
        }
        return false;
    }

    boolean hasValue() {
        return this.value != null;
    }

    BigInteger value() {
        return this.value;
    }

    long longValue() throws RuntimeException {
        if (this.value != null) {
            return this.value.longValue();
        }
        throw new RuntimeException();
    }

    boolean writeValue(Address rangeEnd) {
        if (this.setAddr != null && this.setAddr.compareTo((Object)rangeEnd) < 0) {
            try {
                this.program.getProgramContext().setValue(this.reg, this.setAddr, rangeEnd, this.value);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public boolean setBitAt(Instruction instr, Scalar bit, int rightShiftFactor) {
        if (bit != null) {
            int bitNum = (int)bit.getUnsignedValue() - rightShiftFactor;
            return this.setBitAt(instr, bitNum);
        }
        this.value = null;
        return false;
    }

    public boolean setBitAt(Instruction instr, int bit) {
        if (this.isBitRegister || this.value != null) {
            this.setAddr = instr.getFallThrough();
            if (this.setAddr != null) {
                if (this.value == null) {
                    this.value = BigInteger.valueOf(0L);
                }
                this.value = this.value.setBit(bit);
                if (this.mask != null) {
                    this.value = this.value.and(this.mask);
                }
                return true;
            }
        }
        this.value = null;
        return false;
    }

    public boolean clearBitAt(Instruction instr, Scalar bit, int rightShiftFactor) {
        if (bit != null) {
            int bitNum = (int)bit.getUnsignedValue() - rightShiftFactor;
            return this.clearBitAt(instr, bitNum);
        }
        this.value = null;
        return false;
    }

    public boolean clearBitAt(Instruction instr, int bit) {
        if (this.isBitRegister || this.value != null) {
            this.setAddr = instr.getFallThrough();
            if (this.setAddr != null) {
                this.value = this.value == null ? BigInteger.valueOf(0L) : this.value.clearBit(bit);
                return true;
            }
        }
        this.value = null;
        return false;
    }
}

