/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class AddStackRefCmd
implements Command<Program> {
    private Address fromAddr;
    private int opIndex;
    private int stackOffset;
    private RefType refType;
    private SourceType source;
    private String status;

    public AddStackRefCmd(Address fromAddr, int opIndex, int stackOffset, SourceType source) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.stackOffset = stackOffset;
        this.source = source;
    }

    public AddStackRefCmd(Address fromAddr, int opIndex, int stackOffset, RefType refType, SourceType source) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.stackOffset = stackOffset;
        this.refType = refType;
        this.source = source;
    }

    public boolean applyTo(Program program) {
        Variable var;
        Function f = program.getFunctionManager().getFunctionContaining(this.fromAddr);
        if (f == null) {
            this.status = "Stack reference may only be created within a function";
            return false;
        }
        if (this.refType == null) {
            this.refType = RefTypeFactory.getDefaultStackRefType((CodeUnit)program.getListing().getCodeUnitAt(this.fromAddr), (int)this.opIndex);
        }
        if ((var = f.getStackFrame().getVariableContaining(this.stackOffset)) == null) {
            try {
                f.getStackFrame().createVariable(null, this.stackOffset, null, SourceType.DEFAULT);
            }
            catch (AddressOutOfBoundsException | DuplicateNameException | InvalidInputException e) {
                this.status = e.getMessage();
                return false;
            }
        }
        program.getReferenceManager().addStackReference(this.fromAddr, this.opIndex, this.stackOffset, this.refType, this.source);
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Add Stack Reference";
    }
}

