/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class SetVariableNameCmd
implements Command<Program> {
    private Address fnEntry;
    private String varName;
    private String newName;
    private SourceType source;
    private boolean isParm;
    private String status;

    public SetVariableNameCmd(Variable var, String newName, SourceType source) {
        this.fnEntry = var.getFunction().getEntryPoint();
        this.varName = var.getName();
        this.newName = newName;
        this.source = source;
    }

    public SetVariableNameCmd(Address fnEntry, String varName, String newName, SourceType source) {
        this.fnEntry = fnEntry;
        this.varName = varName;
        this.newName = newName;
        this.source = source;
    }

    public boolean applyTo(Program program) {
        Function f = program.getFunctionManager().getFunctionAt(this.fnEntry);
        if (f == null) {
            this.status = "Function not found";
            return false;
        }
        Symbol s = program.getSymbolTable().getParameterSymbol(this.varName, (Namespace)f);
        if (s == null) {
            s = program.getSymbolTable().getLocalVariableSymbol(this.varName, (Namespace)f);
        }
        if (s == null) {
            this.status = "Variable not found";
            return false;
        }
        Variable var = (Variable)s.getObject();
        this.isParm = var instanceof Parameter;
        try {
            var.setName(this.newName, this.source);
            return true;
        }
        catch (DuplicateNameException e) {
            this.status = e.getMessage();
        }
        catch (InvalidInputException e) {
            this.status = e.getMessage();
        }
        return false;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Rename " + (this.isParm ? "Parameter" : "Variable");
    }
}

