/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;

public class AddFunctionTagCmd
implements Command<Program> {
    private Address entryPoint;
    private String tagName;
    private String errorMsg = "";

    public AddFunctionTagCmd(String tagName, Address entryPoint) {
        this.tagName = tagName;
        this.entryPoint = entryPoint;
    }

    public boolean applyTo(Program program) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(this.entryPoint);
        if (function == null) {
            this.errorMsg = "Function not found at: " + this.entryPoint.toString();
            return false;
        }
        return function.addTag(this.tagName);
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "Add Tag To Function";
    }
}

