/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.util;

import java.util.DoubleSummaryStatistics;
import org.jungrapht.visualization.layout.algorithms.util.RectangleConsumer;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;

public class RectangleSummaryStatistics
implements RectangleConsumer {
    private DoubleSummaryStatistics xValues;
    private DoubleSummaryStatistics yValues;

    public RectangleSummaryStatistics() {
        this.xValues = new DoubleSummaryStatistics();
        this.yValues = new DoubleSummaryStatistics();
    }

    public RectangleSummaryStatistics(int count, int min, int max, int sum) throws IllegalArgumentException {
        this.xValues = new DoubleSummaryStatistics(count, min, max, sum);
        this.yValues = new DoubleSummaryStatistics(count, min, max, sum);
    }

    @Override
    public void accept(Rectangle r) {
        this.xValues.accept(r.x);
        this.xValues.accept(r.maxX);
        this.yValues.accept(r.y);
        this.yValues.accept(r.maxY);
    }

    public void combine(RectangleSummaryStatistics other) {
        this.xValues.combine(other.xValues);
        this.yValues.combine(other.yValues);
    }

    public final long getCount() {
        return this.xValues.getCount();
    }

    public final Point getSum() {
        return Point.of((int)this.xValues.getSum(), (int)this.yValues.getSum());
    }

    public final Point getMin() {
        return Point.of(this.xValues.getMin(), this.yValues.getMin());
    }

    public final Point getMax() {
        return Point.of(this.xValues.getMax(), this.yValues.getMax());
    }

    public final Point getAverage() {
        return Point.of((int)this.xValues.getAverage(), (int)this.yValues.getAverage());
    }

    public String toString() {
        return "RectangleSummaryStatistics{xValues=" + this.xValues + ", heights=" + this.yValues + "}";
    }
}

