/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class LineArrayListWriter
extends Writer {
    protected ArrayList<StringBuilder> lines = new ArrayList();
    protected int lineno = 0;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public LineArrayListWriter() {
        this.newLine();
    }

    public void newLine() {
        ++this.lineno;
        this.lines.add(new StringBuilder());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        String input = new String(cbuf, off, len);
        this.lines.get(this.lineno - 1).append(input);
    }

    public ArrayList<String> getLines() {
        ArrayList<String> result = new ArrayList<String>();
        for (StringBuilder sb : this.lines) {
            result.add(sb.toString());
        }
        return result;
    }

    public String toString() {
        StringBuilder acc = new StringBuilder();
        for (StringBuilder sb : this.lines) {
            acc.append((CharSequence)sb);
            acc.append(LINE_SEPARATOR);
        }
        return acc.toString();
    }
}

