/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;
import java.io.InputStream;

public class MemBufferInputStream
extends InputStream {
    private MemBuffer membuf;
    private int currentPosition;
    private long maxPosition;

    public MemBufferInputStream(MemBuffer membuf) {
        this(membuf, 0, Integer.MAX_VALUE);
    }

    public MemBufferInputStream(MemBuffer membuf, int initialPosition, int length) {
        this.maxPosition = initialPosition + length;
        if (initialPosition < 0 || length < 0 || this.maxPosition > 0x80000000L) {
            throw new IllegalArgumentException();
        }
        this.membuf = membuf;
        this.currentPosition = initialPosition;
    }

    @Override
    public void close() throws IOException {
        this.maxPosition = 0L;
    }

    @Override
    public int available() throws IOException {
        return this.currentPosition >= 0 && (long)this.currentPosition < this.maxPosition ? (int)(this.maxPosition - (long)this.currentPosition) : 0;
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.currentPosition < 0 || (long)this.currentPosition >= this.maxPosition) {
                return -1;
            }
            int result = Byte.toUnsignedInt(this.membuf.getByte(this.currentPosition));
            ++this.currentPosition;
            return result;
        }
        catch (MemoryAccessException e) {
            throw new IOException((Throwable)((Object)e));
        }
    }
}

