/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class HiddenReturnAssign
extends AssignAction {
    public static final String STRATEGY_SPECIAL = "special";
    public static final String STRATEGY_NORMAL = "normalparam";
    private int retCode;

    public HiddenReturnAssign(ParamListStandard res, int code) {
        super(res);
        this.retCode = code;
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new HiddenReturnAssign(newResource, this.retCode);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        HiddenReturnAssign otherOp = (HiddenReturnAssign)op;
        return this.retCode == otherOp.retCode;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        return this.retCode;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_HIDDEN_RETURN);
        if (this.retCode == 3) {
            encoder.writeString(AttributeId.ATTRIB_STRATEGY, STRATEGY_NORMAL);
        } else if (this.retCode == 5) {
            encoder.writeBool(AttributeId.ATTRIB_VOIDLOCK, true);
        }
        encoder.closeElement(ElementId.ELEM_HIDDEN_RETURN);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        String voidLockString;
        this.retCode = 4;
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_HIDDEN_RETURN.name()});
        String strategyString = elem.getAttribute(AttributeId.ATTRIB_STRATEGY.name());
        if (strategyString != null) {
            if (strategyString.equals(STRATEGY_NORMAL)) {
                this.retCode = 3;
            } else if (strategyString.equals(STRATEGY_SPECIAL)) {
                this.retCode = 4;
            } else {
                throw new XmlParseException("Bad <hidden_return> strategy: " + strategyString);
            }
        }
        if (SpecXmlUtils.decodeBoolean((String)(voidLockString = elem.getAttribute(AttributeId.ATTRIB_VOIDLOCK.name())))) {
            this.retCode = 5;
        }
        parser.end(elem);
    }
}

