/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class CodeBlockReferenceImpl
implements CodeBlockReference {
    private CodeBlock source;
    private CodeBlock destination;
    private FlowType flowType;
    private Address reference;
    private Address referent;

    public CodeBlockReferenceImpl(CodeBlock source, CodeBlock destination, FlowType flowType, Address reference, Address referent) {
        this.source = source;
        this.destination = destination;
        this.reference = reference;
        this.referent = referent;
        this.flowType = flowType;
    }

    @Override
    public CodeBlock getSourceBlock() {
        return this.getBlock(this.source, this.destination, this.referent);
    }

    @Override
    public CodeBlock getDestinationBlock() {
        return this.getBlock(this.destination, this.source, this.reference);
    }

    private CodeBlock getBlock(CodeBlock blockNeeded, CodeBlock blockHave, Address addrInBlock) {
        if (blockNeeded == null) {
            CodeBlockModel model = blockHave.getModel();
            try {
                blockNeeded = model.getFirstCodeBlockContaining(addrInBlock, TaskMonitor.DUMMY);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (blockNeeded == null && model instanceof SimpleBlockModel) {
                blockNeeded = ((SimpleBlockModel)model).createSimpleDataBlock(addrInBlock, addrInBlock);
            }
        }
        return blockNeeded;
    }

    @Override
    public FlowType getFlowType() {
        return this.flowType;
    }

    @Override
    public Address getReference() {
        return this.reference;
    }

    @Override
    public Address getReferent() {
        return this.referent;
    }

    @Override
    public Address getSourceAddress() {
        CodeBlock block = this.getSourceBlock();
        if (block != null) {
            return block.getFirstStartAddress();
        }
        return this.referent;
    }

    @Override
    public Address getDestinationAddress() {
        CodeBlock block = this.getDestinationBlock();
        if (block != null) {
            return block.getFirstStartAddress();
        }
        return this.reference;
    }

    public String toString() {
        return String.valueOf(this.referent) + " -> " + String.valueOf(this.reference);
    }
}

