/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.GenericAddress;
import ghidra.program.model.address.SegmentedAddressSpace;

public class SegmentedAddress
extends GenericAddress {
    private final int segment;

    SegmentedAddress(long flat, SegmentedAddressSpace addrSpace) {
        super(SegmentedAddress.adjustOffset(flat, addrSpace), addrSpace);
        this.segment = addrSpace.getDefaultSegmentFromFlat(flat);
    }

    SegmentedAddress(SegmentedAddressSpace addrSpace, int segment, int segmentOffset) throws AddressOutOfBoundsException {
        super(addrSpace, addrSpace.getFlatOffset(segment, segmentOffset));
        this.segment = segment;
    }

    SegmentedAddress(SegmentedAddressSpace addrSpace, long flat) throws AddressOutOfBoundsException {
        super(addrSpace, SegmentedAddress.adjustOffset(flat, addrSpace));
        this.segment = addrSpace.getDefaultSegmentFromFlat(flat);
    }

    private static long adjustOffset(long flat, SegmentedAddressSpace addrSpace) {
        int seg = addrSpace.getDefaultSegmentFromFlat(flat);
        long offset = addrSpace.getDefaultOffsetFromFlat(flat);
        return addrSpace.getFlatOffset(seg, offset);
    }

    public int getSegment() {
        return this.segment;
    }

    public int getSegmentOffset() {
        return (int)((SegmentedAddressSpace)this.addrSpace).getOffsetFromFlat(this.offset, this.segment);
    }

    public SegmentedAddress normalize(int seg) {
        SegmentedAddress res = ((SegmentedAddressSpace)this.addrSpace).getAddressInSegment(this.offset, seg);
        if (res == null) {
            return this;
        }
        return res;
    }

    @Override
    public Address getNewAddress(long byteOffset) {
        SegmentedAddressSpace segSpace = (SegmentedAddressSpace)this.addrSpace;
        SegmentedAddress res = segSpace.getAddressInSegment(byteOffset, this.segment);
        if (res == null) {
            return segSpace.getAddress(byteOffset);
        }
        return res;
    }

    @Override
    public Address getNewAddress(long addrOffset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        return this.getNewAddress(addrOffset);
    }

    @Override
    public Address getNewTruncatedAddress(long addrOffset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        return this.getNewAddress(this.addrSpace.truncateOffset(addrOffset));
    }

    private String getString(long value) {
        String str = Long.toHexString(value);
        return "0000000000000000".substring(0, 4 - str.length()) + str;
    }

    @Override
    public String toString(String prefix) {
        return prefix + this.getString(this.segment) + ":" + this.getString(this.getSegmentOffset());
    }

    @Override
    public Address getPhysicalAddress() {
        return this;
    }

    @Override
    public String toString(boolean showAddressSpace, int minNumDigits) {
        String addr = this.getString(this.segment) + ":" + this.getString(this.getSegmentOffset());
        if (showAddressSpace) {
            addr = this.addrSpace.getName() + ":" + addr;
        }
        return addr;
    }
}

