/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.EquateReference;

class EquateRefDB
extends DatabaseObject
implements EquateReference {
    private DBRecord record;
    private EquateManager equateMgr;
    private AddressMap addrMap;

    EquateRefDB(EquateManager equateMgr, DBObjectCache<EquateRefDB> cache, DBRecord record) {
        super(cache, record.getKey());
        this.addrMap = equateMgr.getAddressMap();
        this.equateMgr = equateMgr;
        this.record = record;
    }

    @Override
    protected boolean refresh() {
        DBRecord rec = this.equateMgr.getEquateRefRecord(this.key);
        if (rec == null) {
            return false;
        }
        this.record = rec;
        return true;
    }

    long getEquateID() {
        return this.record.getLongValue(0);
    }

    @Override
    public Address getAddress() {
        this.checkIsValid();
        long addr = this.record.getLongValue(1);
        return this.addrMap.decodeAddress(addr);
    }

    @Override
    public short getOpIndex() {
        this.checkIsValid();
        return this.record.getShortValue(2);
    }

    @Override
    public long getDynamicHashValue() {
        this.checkIsValid();
        return this.record.getLongValue(3);
    }

    DBRecord getRecord() {
        return this.record;
    }
}

