/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.function.ThunkFunctionAdapterV0;
import ghidra.program.database.map.AddressMap;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class ThunkFunctionAdapter {
    static final String THUNK_FUNCTIONS_TABLE_NAME = "Thunk Functions";
    static final int CURRENT_VERSION = 0;
    static final int LINKED_FUNCTION_ID_COL = 0;
    static final Schema THUNK_FUNCTION_SCHEMA = new Schema(0, "ID", new Field[]{LongField.INSTANCE}, new String[]{"Linked Function ID"});
    protected AddressMap addrMap;

    static ThunkFunctionAdapter getAdapter(DBHandle handle, OpenMode openMode, AddressMap map, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == OpenMode.CREATE) {
            return new ThunkFunctionAdapterV0(handle, map, true);
        }
        try {
            return new ThunkFunctionAdapterV0(handle, map, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == OpenMode.UPDATE) {
                throw e;
            }
            ThunkFunctionAdapter adapter = ThunkFunctionAdapter.findReadOnlyAdapter(handle, map);
            if (openMode == OpenMode.UPGRADE) {
                adapter = ThunkFunctionAdapter.upgrade(handle, adapter, map, monitor);
            }
            return adapter;
        }
    }

    ThunkFunctionAdapter(AddressMap map) {
        this.addrMap = map;
    }

    static ThunkFunctionAdapter findReadOnlyAdapter(DBHandle handle, AddressMap map) {
        return null;
    }

    static ThunkFunctionAdapter upgrade(DBHandle handle, ThunkFunctionAdapter oldAdapter, AddressMap map, TaskMonitor monitor) throws VersionException, IOException {
        return new ThunkFunctionAdapterV0(handle, map, true);
    }

    abstract int getRecordCount();

    abstract RecordIterator iterateThunkRecords() throws IOException;

    abstract RecordIterator iterateThunkRecords(long var1) throws IOException;

    abstract DBRecord getThunkRecord(long var1) throws IOException;

    abstract void removeThunkRecord(long var1) throws IOException;

    abstract void updateThunkRecord(DBRecord var1) throws IOException;

    abstract DBRecord createThunkRecord(long var1, long var3) throws IOException;
}

